(()=>{"use strict";var e={185:(e,t,o)=>{o.d(t,{vF:()=>n});const n={debug:(e,...t)=>{"undefined"!=typeof console&&console.debug&&console.debug(`[LMD Debug] ${e}`,...t)},info:(e,...t)=>{console.info(`[LMD Info] ${e}`,...t)},warn:(e,...t)=>{console.warn(`[LMD Warning] ${e}`,...t)},error:(e,t)=>{console.error(`[LMD Error] ${e}`,t)}}},921:(e,t,o)=>{o.d(t,{Sn:()=>n});const n={PEARSON_DOMAIN:"https://api.pearson.com",LONGMAN_DICTIONARY:"https://www.ldoceonline.com/dictionary/"}}},t={};function o(n){var r=t[n];if(void 0!==r)return r.exports;var s=t[n]={exports:{}};return e[n](s,s.exports,o),s.exports}o.d=(e,t)=>{for(var n in t)o.o(t,n)&&!o.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},o.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t);var n=o(921),r=o(185);class s{static async fetchMainDictionary(e){try{const t=`${this.MAIN_API_ENDPOINT}?limit=5&headword=${encodeURIComponent(e)}`;r.vF.debug("Fetching main dictionary data",{word:e,url:t});const o=await this.makeRequest(t),n=await o.json();return this.processMainApiResponse(n,e)}catch(e){throw r.vF.error("Failed to fetch main dictionary data",e),new Error(`Dictionary lookup failed: ${e instanceof Error?e.message:"Unknown error"}`)}}static async fetchSynonyms(e){try{const t=`${this.MAIN_API_ENDPOINT}?limit=5&synonyms=${encodeURIComponent(e)}`;r.vF.debug("Fetching synonym data",{word:e,url:t});const o=await this.makeRequest(t),n=await o.json();return this.processSynonymApiResponse(n,e)}catch(e){return r.vF.error("Failed to fetch synonym data",e),{}}}static async makeRequest(e){const t=new AbortController,o=setTimeout(()=>t.abort(),this.REQUEST_TIMEOUT);try{const n=await fetch(e,{signal:t.signal,method:"GET",headers:{Accept:"application/json"}});if(clearTimeout(o),!n.ok)throw new Error(`HTTP ${n.status}: ${n.statusText}`);return n}catch(e){if(clearTimeout(o),e instanceof Error&&"AbortError"===e.name)throw new Error("Request timeout");throw e}}static processMainApiResponse(e,t){const o=[];if(!e.total||0===e.total)return r.vF.debug("No results found for word",{searchWord:t}),o;for(const r of e.results){if(t!==r.headword)continue;const e={headword:r.headword,url:`${n.Sn.LONGMAN_DICTIONARY}${r.headword}`};if(r.part_of_speech&&(e.partOfSpeech=r.part_of_speech),r.pronunciations){const t=this.extractAmericanPronunciation(r.pronunciations);t&&(e.ipa=t.ipa,e.audio=t.audio)}if(r.senses&&r.senses[0]){const t=this.extractSenseData(r.senses[0]);Object.assign(e,t)}o.push(e)}return r.vF.debug("Processed main API response",{searchWord:t,resultCount:o.length}),o}static extractAmericanPronunciation(e){if(1===e.length&&e[0].audio)for(const t of e[0].audio)if("American English"===t.lang)return{ipa:e[0].ipa,audio:`${n.Sn.PEARSON_DOMAIN}${t.url}`};for(const t of e)if("American English"===t.lang&&t.ipa){let e;return t.audio&&t.audio.length>0&&(e=`${n.Sn.PEARSON_DOMAIN}${t.audio[0].url}`),{ipa:t.ipa,audio:e}}return null}static extractSenseData(e){const t={};for(const[o,r]of Object.entries(e))Array.isArray(r)?"object"==typeof r[0]&&null!==r[0]&&"text"in r[0]?t.example={text:`ex) ${r[0].text}`,audio:r[0].audio?`${n.Sn.PEARSON_DOMAIN}${r[0].audio[0].url}`:void 0}:"string"==typeof r[0]&&(t.definition=r[0]):"object"==typeof r&&null!==r&&"type"in r?t.grammaticalInfo=r.type:"synonym"===o&&"string"==typeof r&&(t.synonym=r);return t}static processSynonymApiResponse(e,t){const o={};if(!e.total||0===e.total)return o;for(const n of e.results){if(!n.part_of_speech||!n.headword||t===n.headword)continue;const e=`synonyms-${n.part_of_speech.replace(/\s+/g,"")}`;o[e]||(o[e]=[]);const r={headword:n.headword,definition:this.extractDefinitionFromSense(n.senses)};o[e].push(r)}return r.vF.debug("Processed synonym API response",{searchWord:t,synonymCount:Object.keys(o).length}),o}static extractDefinitionFromSense(e){if(!e||!Array.isArray(e)||!e[0])return;const t=e[0];for(const e of Object.values(t))if(Array.isArray(e)&&"string"==typeof e[0])return e[0]}}s.MAIN_API_ENDPOINT=`${n.Sn.PEARSON_DOMAIN}/v2/dictionaries/ldoce5/entries`,s.REQUEST_TIMEOUT=1e4})();