/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

// jpn-1

// Important!
// Isolate from global scope
(function uBOL_cssGenericImport() {

/******************************************************************************/

const genericSelectorMap = [[3439,".full-tab > div.full-right-col"],[1402,".__isboostReturnAd"],[1276,".__uz__third_party_ad"],[4092,"._popIn_infinite_ad"],[3071,"._popIn_infinite_video"],[3246,"._popIn_recommend_ad_section"],[4034,"._popIn_recommend_article_ad"],[239,"._popIn_recommend_article_ad_reserved"],[182,".google-afc-image"],[2407,"#ad-60days-area"],[554,"#ad-recommend"],[913,"#fc2_bottom_bnr"],[2311,"#float-bnr"],[1657,"#fluct-pc-sticky-ad"],[1633,"#footerafficode"],[968,"#geniee_overlay_outer"],[3233,"#headerafficode"],[2250,"#id_ads_enc"],[1062,"#im_panel"],[2470,"#im_panel_pc"],[1975,"#im_panel_pc_left"],[433,"#joboxAd"],[211,"#kauli_yad_1"],[208,"#kauli_yad_2"],[209,"#kauli_yad_3"],[214,"#kauli_yad_4"],[2008,"#meerkat-contents"],[3918,"#ninja-blog-inactive"],[3378,"#overlay-ad-div-id"],[1867,"#prtaglink"],[861,"#seesaa-bnr"],[4079,"#trackword_banner"],[1495,".NinjaEntryCommercial"],[2704,".ad-in-feed-list"],[3533,".ad-single-h2"],[1881,".ad_splify"],[1490,".ad1-title"],[2773,".adPost"],[799,".ad_overlay"],[3203,".adarea-box"],[3277,".adboxcontainer_t"],[10,".adgoogle"],[337,".adgoogle-wrapper"],[3105,".admax-ads"],[1166,".ads-flexbox"],[4061,".advrbox,\n.double-rectangle"],[3705,".archive__item-infeedPc1,\n.archive__item-infeedPc2,\n.archive__item-infeedPc3"],[921,".archiveItem-infeed"],[1679,".archiveList-infeed"],[1224,".blogroll-ad-text"],[2282,".blogroll_ads"],[3412,".bns-bl"],[684,".c-infeedAd"],[2099,".csw_non_search_ad_block_2"],[3187,".diver_widget_adarea"],[3006,".ggbox"],[2316,".google-2ad"],[807,".google-2ad-a,\n.google-2ad-b,\n.google-2ad-c,\n.google-2ad-f,\n.google-2ad-h,\n.google-2ad-m"],[3628,".google-2ad-mid"],[706,".google-user-ad-728"],[2789,".google-user-ad-side1"],[2958,".i2i-content-bottom"],[2865,".i2i-content-middle"],[729,".i2i-content-top"],[2824,".i2i-header"],[2234,".insentence-adsense"],[1193,".insentence-adsense2"],[184,".invalid + .rakko_area"],[1711,".itiran-ad"],[1857,".js-kb-click"],[3086,".logly-lift-ad-ad"],[4063,".master-post-advert"],[789,".my_ads"],[2278,".p-entry__ad"],[1392,".plugin-rakuten"],[1141,".rectangle > div.rectangle__item + .rectangle__title"],[2645,".rectangle__item"],[3152,".related-ad-area"],[3032,".seesaa-cmn__pr"],[618,".sherpa-component[data-ad_type]"],[2988,".side_widget_surfing_adsense_widget"],[3133,".sleeping-ad-in-entry"],[2339,".sleeping-ads"],[1826,".sponsor-h2-center"],[3644,".sponsor-top"],[1219,".st-h-ad"],[2162,".st-infeed-adunit"],[1409,".st-magazine-infeed"],[105,".thk_ps_widget"],[2938,".veu_insertAds"],[3386,".widget_common_ad"],[1907,".widget_fit_aditem_class"],[2965,".widget_mobile_ad"],[2921,".widget_pc_ad"],[1999,".widget_st_custom_html_ad_widget"],[3746,".widget_swell_ad_widget"],[2913,".widget_tsnc_ad_custom_html"],[1229,".widget_tsnc_ads_custom_html"],[496,".wipe-ad-div-class"],[783,".ys-ad-content"],[3514,"iframe.lazyloaded[data-src^=\"https://ad.jp.ap.valuecommerce.com/\"]"],[132,".plugin-freearea > div[id^=\"msmaflink\"],\n.plugin-freearea a[href*=\"//al.\"][href*=\"/?lurl=\"],\n.plugin-freearea a[href*=\"amazon.co.jp\"],\n.plugin-freearea a[href*=\"e-nls.com/access.php\"]"],[3054,".plugin-memo > .side > .amazon,\n.plugin-memo > .side > a[href*=\"//al.\"][href*=\"/?lurl=\"],\n.plugin-memo > .side > a[href*=\"amazon.co.jp/exec/\"],\n.plugin-memo > .side > a[href*=\"e-nls.com/access.php\"],\n.plugin-memo > .side > a[href^=\"https://affiliate.suruga-ya.jp\"]"],[3172,".t_b > a[href^=\"https://hb.afl.rakuten.co.jp\"],\n.t_b > div > a[href^=\"https://al.\"][href*=\"/?lurl=\"],\n.t_b ~ .amazon,\n.t_b ~ a[href^=\"https://amzn.to\"],\n.t_b ~ a[href^=\"https://hb.afl.rakuten.co.jp\"],\n.t_b ~ a[href^=\"https://www.amazon.co.jp\"],\n.t_b ~ div > a[href^=\"https://al.\"][href*=\"/?lurl=\"],\n.t_b ~ div > a[href^=\"https://www.amazon.co.jp\"]"],[1950,".textwidget a[href^=\"https://pcmax.jp/lp/?ad_id=\"] > img"],[4025,".widget_custom_html > .custom-html-widget > a[href^=\"https://www.e-nls.com/access.php\"]"]];
const genericExceptionSieve = [2695,3848,586,3012,1294,1319,924,3183,2082,374,4053,2876,805,3930,2050,3903,3984,894,3317,1363,3695,3561,1353,1605,822,1302,130,162,116,3233,11,3136,3746,2607,1199,861,4092,605,3560,1575,1118,1458,3080,1979,3185,1225,1219,3900,2406,4063,3635,566,2200,3910,3627,1409,2645,2322,3642,2632,3889,523,3008,1649,105,1243,16,2098,3097,2213,1867,3388,3152,239,3279,2125,1336,1949,976,1108,1621,394,1210,636];
const genericExceptionMap = [["niji-gazo.com",".banner-ad"],["mtgames.jp",".adspace"],["tuyano.com",".adspace"],["blog.2nt.com",".adspace\n.AdSense"],["cad-data.com",".adspace"],["video.tv-tokyo.co.jp",".adspace\n#adspace\n.ad-placeholder:not(#filter_ads_by_classname):not(#detect_ad_empire):not(#detect):not(.adsbox)"],["crefan.jp",".adspace"],["shukatsubbs.com",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["localch.net",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["best-hit.tv",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["h178.com",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["j-baseball.club",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["j-basketball.club",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["j-rugby.club",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["j-volleyball.club",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["jukenbbs.com",".ad-space:not(.textads)\n.div-gpt-ad:not([style^=\"width: 1px; height: 1px;\"])\n.amp_ad"],["mytry.jp",".ad_box:not(.text-ad)"],["hamadasyuzou.co.jp",".ad_box:not(.text-ad)\n.ad_bottom\n.ad_contents\n.ad_title\n.ad_wrapper"],["echo-gr.co.jp",".ad_box:not(.text-ad)\n#footer_ad"],["echo-kensetu.jp",".ad_box:not(.text-ad)\n#footer_ad"],["fujiidera-gojokai.or.jp",".ad_box:not(.text-ad)\n#footer_ad"],["fet.co.jp",".ad_box:not(.text-ad)"],["takken-k.co.jp",".ad_box:not(.text-ad)"],["zanmai.co.jp",".ad_box:not(.text-ad)"],["hatenablog.com","#adframe:not(frameset)"],["puzzle-ch.com","#adframe:not(frameset)"],["nieru.net",".ad-space\n.adWidget"],["tters.jp",".ad-section"],["egotter.com",".adsense-container"],["tokyo-sports.co.jp",".ad-text\n.adBlock\n.adContent\n.adSense\n.ads-banner\n.textad\n.view_ad"],["asobeans.jp",".ad_block"],["manga1001.*",".c-ads\n.body-top-ads"],["ma-bank.net",".ad_div\n#ad_area\n#adspace"],["coolpan.net",".ad-area:not(.text-ad)"],["applion.jp",".ads-ad"],["mobilegadget.jp",".header-ad"],["pooh2rohhobby.blogspot.com","#ad-target"],["nogizaka46-matome.jp","#headerafficode"],["etude000.com",".top-ad\n.thk_ps_widget"],["tennisclassic.jp",".ad-sp"],["fob.jp",".widget_swell_ad_widget"],["rankingoo.net",".widget_swell_ad_widget"],["panasonic.biz",".ad-result"],["asianoneta.blog.jp",".side_ad"],["mognavi.jp",".side_ad"],["gameranbu.jp",".side_ad"],["lamire.jp",".ad-unit:not(.textads)"],["miitus.jp",".new-ad-box"],["matome.f-book.net",".section_ad"],["app-story.net","#AdBlock"],["news.merumo.ne.jp",".adBox"],["asahi-net.jp",".wrapper_ad"],["au.com",".wrapper_ad"],["eowebmail.eonet.jp",".wrapper_ad"],["hwm.hi-ho.ne.jp",".wrapper_ad"],["icloud.com",".wrapper_ad"],["mail.google.com",".wrapper_ad"],["mail.nifty.com",".wrapper_ad"],["mail.smt.docomo.ne.jp",".wrapper_ad"],["mail.yahoo.co.jp",".wrapper_ad"],["msg.dream.jp",".wrapper_ad"],["ocn.ne.jp",".wrapper_ad"],["outlook.live.com",".wrapper_ad"],["outlook.office.com",".wrapper_ad"],["plala.or.jp",".wrapper_ad"],["proton.me",".wrapper_ad"],["so-net.ne.jp",".wrapper_ad"],["tp1.jp",".wrapper_ad"],["tutanota.com",".wrapper_ad"],["wakwak.com",".wrapper_ad"],["web.mail.goo.jp",".wrapper_ad"],["webmail.gol.com",".wrapper_ad"],["webmail.softbank.jp",".wrapper_ad"],["wms.sso.biglobe.ne.jp",".wrapper_ad"],["nijisenmon.work",".ad.widget\n.st-h-ad"],["ironsaga-msoku.xyz",".ad.widget"],["takushoku.info",".ad.widget"],["manpukunews.blog.jp",".ads01"],["kininaru-geinou-m.blog.jp",".ads01"],["hinative.com",".banner_header"],["cookpad.com",".banner_header"],["otonary.net",".master-post-advert"],["yama.minato-yamaguchi.co.jp","#ad6\n.sidead"],["jmd.co.jp",".widget-ad"],["torisetsu.biz",".ad_item"],["jj-jj.net",".ad_container\n.ad-rect"],["macaro-ni.jp",".rectangle__item"],["ign.com",".zad"],["kaerudx.com",".adArea\n.ad-center"],["teny.co.jp",".s-ad"],["kana-ot.jp",".boxAds"],["minpo.jp",".ads970"],["osusume.mynavi.jp",".ad-widget"],["mitsubishi-motors.co.jp",".top-banners"],["agonp.jp",".top-banners"],["yamaya.jp",".top-banners"],["natsume-anime.jp","#topBanners"],["kichijo-joshi.jp",".sp_ad"],["taiju-life.co.jp",".spLinks"],["hoken-all.co.jp",".bottom_ad"],["cotoro.net",".bottom_ad"],["favoriteslibrary-books.com",".bottom_ad"],["hakenreco.com",".bottom_ad"],["shellbys.com",".bottom_ad"],["tipstour.net",".bottom_ad"],["maidonanews.jp",".module-ad"],["webcartop.jp",".single-ads"],["eromanga-school.com",".related-ad-area"],["komachi.yomiuri.co.jp","._popIn_recommend_article_ad_reserved"],["nikke-jp.com",".ad_content"],["point-g.rakuten.co.jp",".searchAd"],["netmile.co.jp",".ad-txt"],["1sshindo.com","#footer_ad"],["akashi-kodomo-zaidan.jp","#footer_ad"],["alps-beauty-salon.com","#footer_ad"],["art-green.co.jp","#footer_ad"],["ascon-blast.co.jp","#footer_ad"],["bees-garden.jp","#footer_ad"],["bellys.jp","#footer_ad"],["betsukawa.co.jp","#footer_ad"],["chuo-hp.jp","#footer_ad"],["courier.co.jp","#footer_ad"],["e-shinwa.com","#footer_ad"],["ecsatonoie.jp","#footer_ad"],["edel-support.com","#footer_ad"],["ex-daito.jp","#footer_ad"],["familykanko.co.jp","#footer_ad"],["friends-animal.com","#footer_ad"],["fuji-sho.jp","#footer_ad"],["fukukanren.jp","#footer_ad"],["ginga-clinic.com","#footer_ad"],["ginganosato.com","#footer_ad"],["gms.or.jp","#footer_ad"],["guidepost.co.jp","#footer_ad"],["hairplace-patio.com","#footer_ad"],["hairsalon-duo.com","#footer_ad"],["hakuaikai-kitakami.or.jp","#footer_ad"],["hanamaki-fureai.jp","#footer_ad"],["handinhandjp.com","#footer_ad"],["harayamadai-kg.jp","#footer_ad"],["heiseidensetsu.co.jp","#footer_ad"],["hello-work.co.jp","#footer_ad"],["hogaraka.gr.jp","#footer_ad"],["hongakuji.jp","#footer_ad"],["icd-connect.co.jp","#footer_ad"],["ichinohe-hp.com","#footer_ad"],["ikiiki.toyama.jp","#footer_ad"],["ims-kt.co.jp","#footer_ad"],["isawa-hp.com","#footer_ad"],["isawabunso.com","#footer_ad"],["iyasakaseitai.com","#footer_ad"],["kaigowakouwa.jp","#footer_ad"],["kekkangeka.com","#footer_ad"],["ken6-fudousan.co.jp","#footer_ad"],["kennan-crane.co.jp","#footer_ad"],["kitakami-node.co.jp","#footer_ad"],["kitakamicity.jp","#footer_ad"],["kk-haruna.co.jp","#footer_ad"],["kogane.or.jp","#footer_ad"],["kumedakango.jp","#footer_ad"],["kuramoto-sekizai.com","#footer_ad"],["kyoyu-k.co.jp","#footer_ad"],["marineworld-tanabe.com","#footer_ad"],["media-pc.co.jp","#footer_ad"],["mfutaba.jp","#footer_ad"],["mitosan.co.jp","#footer_ad"],["mizusawarikuso.com","#footer_ad"],["modern-h.jp","#footer_ad"],["momiki-express.co.jp","#footer_ad"],["momokuri.co.jp","#footer_ad"],["nisseijushi.co.jp","#footer_ad"],["nittofunka.co.jp","#footer_ad"],["okameshouten.jp","#footer_ad"],["osanais.co.jp","#footer_ad"],["porco-blu.com","#footer_ad"],["rfj.co.jp","#footer_ad"],["rokuhara.co.jp","#footer_ad"],["sakitamas.com","#footer_ad"],["sento-sakai.co.jp","#footer_ad"],["sfv.co.jp","#footer_ad"],["shikokuyanehan.sakura.ne.jp","#footer_ad"],["shimura-geo.co.jp","#footer_ad"],["shinko.main.jp","#footer_ad"],["sinkyu-c.jp","#footer_ad"],["site-jobyellnet.main.jp","#footer_ad"],["skn-fc.jp","#footer_ad"],["spec-com.co.jp","#footer_ad"],["sugawa-mokko.jp","#footer_ad"],["suzukireform.jp","#footer_ad"],["syahokyo-saga.or.jp","#footer_ad"],["t-suiko.jp","#footer_ad"],["taiyo-valve.co.jp","#footer_ad"],["takaidahoikuen.jp","#footer_ad\n#top_ad"],["takasaki-shika.com","#footer_ad"],["takatagumi.co.jp","#footer_ad"],["technobell.co.jp","#footer_ad"],["tenmashatai.com","#footer_ad"],["tiara-y.jp","#footer_ad"],["tohoku-juken.co.jp","#footer_ad"],["tohokuseimitsu.co.jp","#footer_ad"],["totalsupport-kitakami.com","#footer_ad"],["tsc.co.jp","#footer_ad"],["twinklesnow.com","#footer_ad"],["umenohisagi.jp","#footer_ad"],["urban-karuizawa.co.jp","#footer_ad"],["vook.vc","#footer_ad"],["yagate1.co.jp","#footer_ad"],["yamashitajari.com","#footer_ad"],["yokosawa.jp","#footer_ad"],["yonoyouchien.jp","#footer_ad"],["yuhki-elec.co.jp","#footer_ad"],["yuimarl-kids.jp","#footer_ad"],["yumekoumuten.com","#footer_ad"],["3faithsdjschool.com",".footer_ad"],["3plmnt.co.jp",".footer_ad"],["abuto-kankou.co.jp",".footer_ad"],["aigato.jp",".footer_ad"],["akihabara-eye.com",".footer_ad"],["alpenhaime.gr.jp",".footer_ad"],["alpha-eng.jp",".footer_ad"],["andocl.jp",".footer_ad"],["anshinhome.co.jp",".footer_ad"],["aoclinic.jp",".footer_ad"],["appreco.com",".footer_ad"],["biz-point.jp",".footer_ad"],["btktool.co.jp",".footer_ad"],["bodymake-onix.co.jp",".footer_ad"],["carrier-agency.com",".footer_ad"],["ch-matsumoto.jp",".footer_ad"],["chikushi-410.com",".footer_ad"],["co-nagayama.co.jp",".footer_ad"],["cohaco.jp",".footer_ad"],["dai2aikoen.jp",".footer_ad"],["dw-clinic.jp",".footer_ad"],["enemix.jp",".footer_ad"],["enomoto-c.com",".footer_ad"],["flair.co.jp",".footer_ad"],["flexs.co.jp",".footer_ad"],["foresight-1998.co.jp",".footer_ad"],["fujimidai-hifuka.jp",".footer_ad"],["fukamachitakkyu.com",".footer_ad"],["goro-bei.com",".footer_ad"],["gozamisaki.com",".footer_ad"],["herb-teien.com",".footer_ad"],["higashin-ls.co.jp",".footer_ad"],["himawari-clinic.com",".footer_ad"],["hkcg.co.jp",".footer_ad"],["hokkaido-nomad.co.jp",".footer_ad"],["htk-kobechuo.jp",".footer_ad"],["iida-dent.jp",".footer_ad"],["integration.ne.jp",".footer_ad"],["itawarinoyu.jp",".footer_ad"],["iwasaki-clinic.jp",".footer_ad"],["izumi3.com",".footer_ad"],["j-sonic.co.jp",".footer_ad"],["japan-quartzclub.com",".footer_ad"],["jashoteltakayama.jp",".footer_ad"],["jdc-kaigyousien.jp",".footer_ad"],["kaidentalclinic.jp",".footer_ad"],["kakiemon.co.jp",".footer_ad"],["kameman.co.jp",".footer_ad"],["katekin.com",".footer_ad"],["kenbunkai-yamaguchi.jp",".footer_ad"],["kitaoku.jp",".footer_ad"],["kiyotaclinic.or.jp",".footer_ad"],["kobayashi-eyeclinic.jp",".footer_ad"],["kotoridc.jp",".footer_ad"],["kouden-s.jp",".footer_ad"],["kusatsu-law.jp",".footer_ad"],["kyoai.or.jp",".footer_ad"],["kyowa-tekko.jp",".footer_ad"],["lanai-beauty.com",".footer_ad"],["m-publicgolf.com",".footer_ad"],["m-shika.jp",".footer_ad"],["maff.go.jp",".footer_ad"],["magome-eye.jp",".footer_ad"],["manaao-kitchen.but.jp",".footer_ad"],["manaao-kitchen.com",".footer_ad"],["manabe-ortho.or.jp",".footer_ad"],["marineplaza.co.jp",".footer_ad"],["marushime21.jp",".footer_ad"],["me-cell.jp",".footer_ad"],["metal-model.com",".footer_ad"],["mikawapropeller.co.jp",".footer_ad"],["mikielectric.co.jp",".footer_ad"],["minami-ise.jp",".footer_ad"],["miyazu-matsukaze.jp",".footer_ad"],["mizuiwa-un.co.jp",".footer_ad"],["mj-pro.jp",".footer_ad"],["mkc6.com",".footer_ad"],["mohara-clinic.jp",".footer_ad"],["nakaod.com",".footer_ad"],["nakase-dc.jp",".footer_ad"],["nanjyoen.com",".footer_ad"],["nikunotoriko.co.jp",".footer_ad"],["nnbs.co.jp",".footer_ad"],["nousui-shop.com",".footer_ad"],["okamoto-fdc.jp",".footer_ad"],["okayamanavi.jp",".footer_ad"],["okudaganka.jp",".footer_ad"],["omoiyari-edu.jp",".footer_ad"],["onsinkai.jp",".footer_ad"],["picring.co.jp",".footer_ad"],["plateck.jp",".footer_ad"],["rikkyo-dps.com",".footer_ad"],["rousai-kenkyujyo.co.jp",".footer_ad"],["ruhe-mental.jp",".footer_ad"],["s-gp.co.jp",".footer_ad"],["s-shizai.jp",".footer_ad"],["saipri.com",".footer_ad"],["saizenji.or.jp",".footer_ad"],["sakataengei.jp",".footer_ad"],["sakoken.co.jp",".footer_ad"],["sanadayamashika.jp",".footer_ad"],["sanagawa-dental.com",".footer_ad"],["sanchang.co.jp",".footer_ad"],["sapporocity-law.jp",".footer_ad"],["satsumacon.co.jp",".footer_ad"],["sec-architects.com",".footer_ad"],["seinankaihatsu.co.jp",".footer_ad"],["shibusaki.co.jp",".footer_ad"],["shineiengineer.co.jp",".footer_ad"],["shinritsu.com",".footer_ad"],["shizuokakenro.jp",".footer_ad"],["sosus.jp",".footer_ad"],["southluck.co.jp",".footer_ad"],["sweet-nurse.ne.jp",".footer_ad"],["t-mclinic.jp",".footer_ad"],["t-u-advance.jp",".footer_ad"],["tairyouen.com",".footer_ad"],["takara-pd.co.jp",".footer_ad"],["takei-kogyo.jp",".footer_ad"],["talknet.jp",".footer_ad"],["tnk-koei.co.jp",".footer_ad"],["tokyowest-ah.jp",".footer_ad"],["tonakbuque.co.jp",".footer_ad"],["tousyo-k.co.jp",".footer_ad"],["tsurukawadai.jp",".footer_ad"],["ug-home.co.jp",".footer_ad"],["vario.jp",".footer_ad"],["volleyball-u.jp",".footer_ad"],["w-dc.jp",".footer_ad"],["wazumi.jp",".footer_ad"],["wic-life.com",".footer_ad"],["yaizuminsho.com",".footer_ad"],["yamadakaki.jp",".footer_ad"],["yamahana-ds.com",".footer_ad"],["yamanogaku.com",".footer_ad"],["yokohama-kenshu.jp",".footer_ad"],["yokoyamaseikotsuin.jp",".footer_ad"],["yotsuba-sapporo.com",".footer_ad"],["yuukaen.jp",".footer_ad"],["mamastar.jp",".adstop"],["arukikata.co.jp",".ad_btn"],["25news.jp",".has-ad"],["xn--0et88ccz6awh1a.biz",".has-ad"],["920ryu.blog.fc2.com","#scroll_ad"]];

if ( genericSelectorMap ) {
    const map = self.genericSelectorMap =
        self.genericSelectorMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericSelectorMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before},\n${entry[1]}`);
            }
        }
    } else {
        self.genericSelectorMap = new Map(genericSelectorMap);
    }
    genericSelectorMap.length = 0;
}

if ( genericExceptionSieve ) {
    const hashes = self.genericExceptionSieve =
        self.genericExceptionSieve || new Set();
    if ( hashes.size !== 0 ) {
        for ( const hash of genericExceptionSieve ) {
            hashes.add(hash);
        }
    } else {
        self.genericExceptionSieve = new Set(genericExceptionSieve);
    }
    genericExceptionSieve.length = 0;
}

if ( genericExceptionMap ) {
    const map = self.genericExceptionMap =
        self.genericExceptionMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericExceptionMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before}\n${entry[1]}`);
            }
        }
    } else {
        self.genericExceptionMap = new Map(genericExceptionMap);
    }
    genericExceptionMap.length = 0;
}

/******************************************************************************/

})();

/******************************************************************************/
