/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

// ublock-filters

// Important!
// Isolate from global scope
(function uBOL_cssGenericImport() {

/******************************************************************************/

const genericSelectorMap = [[2916,".ez-sidebar-wall"],[501,".aff-content-col"],[3358,".aff-inner-col"],[3064,".aff-item-list"],[3345,".inplayer-ad"],[289,".inplayer_banners"],[2269,".in_stream_banner"],[2548,".reklama:not(.ads)"],[1601,".trafficjunky-float-right"],[3707,".happy-inside-player"],[2029,".blocker-notice"],[298,".blocker-overlay"],[2021,".exo-horizontal"],[3883,".ave-pl"],[615,".bottom-hor-block"],[4016,".brs-block"],[24,".advboxemb"],[3999,".wgAdBlockMessage"],[906,".glx-watermark-container"],[2287,"#sidearm-adblock-modal"],[794,".overlay-advertising-new,\n.samBannerUnit"],[1727,".header-menu-bottom-ads"],[1156,".rkads"],[936,"#bt-ads"],[1514,".mdp-deblocker-wrapper"],[1652,".amp-ad-inner"],[2022,"#placeAds"],[1515,".samCodeUnit"],[1063,".nav-item[href^=\"https://candyai.gg/\"]"],[3086,".bloc-pub"],[4000,".bloc-pub2"],[3755,"#invideo_data"],[1932,"#invideo_2"],[1303,".hor_banner"],[3133,"#invid_call"],[2341,"#invideo_new"],[2078,".aan_fake"],[401,".aan_fake__video-units"],[782,".rps_player_ads"],[355,".preroll-blocker"],[1342,"#dontfoid"],[2005,"#advert-header:not(:empty)"],[1112,"#adSpecial:not(:empty)"],[678,"#adzerk:not(:empty)"],[450,"#buy-sell-ads:not(:empty)"],[3673,"#leader_ad:not(:empty)"],[804,"#midadd:not(:empty)"],[2955,"#go-to-top + div[id][class]"],[1130,"#st-ami + div[id][class*=\" \"]"],[2050,".close-btn[onclick=\"closeAd()\"]"],[4001,".close-btn2[onclick=\"closeAd2()\"],\n.close-btn3[onclick=\"closeAd3()\"],\n.close-btn4[onclick=\"closeAd4()\"],\n.adde_modal-overlay"],[2103,".ark-ad-message"],[525,"#vidcloud-player > #overlay-container"],[1196,".bb ~ main#container .containerAds"],[2935,"html[lang=\"vi\"] > body.home > .mmo-fixbot"],[322,"html[lang=\"vi\"] > body[class] .mmo"],[3413,"html[lang=\"vi\"] > body[class] > .mmo + .mzdal"],[4,"html[lang=\"vi\"] > body[class] > div.container[style^=\"margin-bottom:\"] + header#header + .bg-overlay.active"],[2483,".fints-block__row"],[2117,"#playerOverlay[style=\"position:absolute; z-index:3\"]"],[693,".full-ave-pl"],[1739,".full-bns-block"],[2929,".vertbars"],[2411,".video-brs"],[151,"#plban"],[587,".player-bns-block"],[2112,"div#spot-holder.spot-holder[style=\"display: block;\"]"],[1988,".gallery-bns-bl"],[2790,"#stop_ad"],[2075,"#stop_ad2"],[2898,".stream-item-widget"],[2796,"#ad_300:not([style^=\"position: absolute; left: -5000px\"])"],[2594,"#ad_728:not([style^=\"position: absolute; left: -5000px\"])"],[1353,"#ad_area:not([style^=\"position: absolute; left: -5000px\"])"],[4051,"#ad_big:not([style^=\"position: absolute; left: -5000px\"])"],[3850,"#ad_box:not([style^=\"position: absolute; left: -5000px\"])"],[2877,"#ad_footer:not([style^=\"position: absolute; left: -5000px\"])"],[858,"#ad_slot:not([style^=\"position: absolute; left: -5000px\"])"],[3221,"#ad_space:not([style^=\"position: absolute; left: -5000px\"])"],[924,"#adframe:not(frameset):not([style^=\"position: absolute; left: -5000px\"])"],[817,"#adheader:not([style^=\"position: absolute; left: -5000px\"])"],[12,"#ads-1:not([style^=\"position: absolute; left: -5000px\"])"],[1202,"#ads-banner:not([style^=\"position: absolute; left: -5000px\"])"],[1239,"#ads-footer:not([style^=\"position: absolute; left: -5000px\"])"],[1605,"#adspace:not([style^=\"position: absolute; left: -5000px\"])"],[239,"#adsquare:not([style^=\"position: absolute; left: -5000px\"])"],[3951,"#banner468:not([style^=\"position: absolute; left: -5000px\"])"],[3248,"#banner728x90:not([style^=\"position: absolute; left: -5000px\"])"],[2730,".google-ad:not(.testAd)"],[2633,".adslot:not(.text-ad)"],[2121,".adslot_1:not(.text-ad)"],[599,".ad_slot:not(.text-ad)"],[2891,".adunit:not(.text-ad)"],[2401,".ad-link:not(.adsbox)"],[1575,".ad-unit:not(.adsbox, .text-ad, .textads):not([style^=\"width: 1px; height: 1px; position: absolute;\"])"],[597,".ad_unit:not(.text-ad)"],[1317,".ad-slot:not(.adsbox):not(.adsbygoogle)"],[757,".ad-300x250:not(.ads)"],[1437,".adsbyrunactive"],[3053,"#tabVideo > .rmedia"],[2199,"#adContext:not(:empty)"],[2844,"#ad_img:not(:empty)"],[2870,"#downloadAd:not(:empty)"],[1845,"#topBannerAd:not(:empty),\n#topbannerad:not(:empty)"],[898,"#weatherad:not(:empty)"],[130,".ad-placeholder:not(#detect, #detect_ad_empire, #filter_ads_by_classname, .adsbox)"],[1917,".ad-content:not(:empty),\n.sharethis-inline-share-buttons.st-hidden"],[800,".ads-iframe:not([style=\"position: absolute; left: -10px; top: -10px;\"])"],[1903,"#micast_ads"],[2606,".adde_modal_detector"],[3210,"#video-id_fluid_html_on_pause"],[2085,".ninja-recommend-block"],[3775,".ad-zone:not(.adsbox, .textads)"],[586,".ad-space:not(.adbox, .adsbox, .textads)"],[3514,"iframe.lazyloaded[data-src^=\"https://rcm-fe.amazon-adsystem.com/\"]"],[2792,".jwplayer ~ div[style=\"position:absolute;top:0;left:0;width: 100%;height: 100%;z-index:2147483647\"]"],[1003,".fp-player > div[style=\"position: absolute; inset: 0px; overflow: hidden; z-index: 160; background: transparent; display: block;\"]"],[3733,"#anuncio"],[1622,"#player div[style$=\"cursor: pointer; position: absolute; width: 100%; height: 100%; padding: 1rem; z-index: 2147483647;\"]"],[2694,"#video_player ~ div[id] div[style^=\"position:fixed;inset:0px;z-index:\"]"],[3788,".fp-ui > a[href][target=\"_blank\"][style^=\"position: absolute; inset: 0px;\"]"],[268,"#adyes"],[3408,"#donate > a[href][style][onclick=\"thank_you()\"][target=\"_blank\"][rel=\"nofollow\"]"],[246,".ads-btns"],[1328,".infiniteads_placeholder"],[207,"html[lang][style^=\"--main-bg-color\"] > body:not([class]):not([id]) > div#container[style=\"visibility: visible;\"] > div#banner[style=\"opacity:0\"] ~ main:not([class]):not([id]) > div#message"],[3000,"#TapatalkFooterDesktopAds"],[2532,"#adbd.overdiv"],[2660,".kln > a[href^=\"https://www.polybuzz.ai/\"]"],[496,"a.poly-title[href^=\"https://www.polybuzz.ai/\"]"],[2546,"a[href^=\"https://www.polybuzz.ai/\"] img.responsive-image"],[374,"#close-teaser"],[3043,"#teaser3[style^=\"width: 100%;height:0;text-align: center;display: scroll;position:fixed;\"]"],[3588,".gliaplayer-container"],[312,"#adbtm[onclick=\"badr();\"]"],[2421,"button.btn[data-openuri*=\"/4/\"]"],[824,"#clickCatcher31,\n#clickCatcher32"],[2850,"#zdn-adblock-overlay"],[575,".wp-block-savage-platform-primis-video"],[1200,".menu-item a[href^=\"https://go.rmhfrtnd.com\"]"],[883,"a.tdn[href^=\"https://landing.brazzersnetwork.com/\"]"],[3678,".addthis_toolbox"]];
const genericExceptionSieve = [2516,49,2832,836,135,1905,920,621,2510,2509,2623,3786,2250,1210,364,2244,116,3818,612,1319,4092,1325,164,3373,2973,3625,1145,1695,167,3005,3923,983,382,153,2246,3368,69,3733,602,2041,1555,3870,1710,3705,622,1494,1625,2927,3237,3444,3624,3171,2770,2363,3023,2777,228,3866,2462,3053,2357,1297,655,134,1730,1597,2401,3916,3995,410,3123,830,682,947,3791,3788,1339,1113,899,3675,1418,77,2692,4068,1430,1141,1479,2303,3050,2048,2548,604,2707,2178,3144,1503,2021,286,2947,1204,356,2965,1565,1384,2695,183,1302,3409,1575,1751,2730,329,3627,3038,2506,119,2421,2392,1317,3850,3221,924,1605,2633,2313,2773,3984,1305,2522,485,1917,2528,2445,472,1979,138,2478,659,1704,586,4065,3884,155,1671,3676,1530,3804,397,2403,615,1653,617,306,3345,1620,3927,1489,2177,2082,1468,3903,697,3148,730,1466,130,2311,2070,2470];
const genericExceptionMap = [["youtube.com","#player-ads"],["japscan.*",".navbar-nav > li.nav-item > a.text-truncate.nav-link.font-weight-bold[href*=\"?\"]\nbody > div.full-container > div.full-container.text-center > div.mt-2[style=\"margin: 0px auto; display: block;\"] > a.Aikoi.donate[target=\"_blank\"][rel][href^=\"https://www.longosto.shop/?utm_source=\"] > img.img-fluid"],["veev.to",".avb-active"],["orange.fr","#o_carrepub"],["energy.de","#ad_home"],["reyada.com",".ads_area"],["hintergrundbild.org",".ads1"],["wallpaperaccess.com",".ads1"],["kotaku.com","#dfp-ad-2\n#dfp-ad-1"],["calgarysun.com",".adsizewrapper"],["canoe.com",".adsizewrapper"],["edmontonsun.com",".adsizewrapper"],["financialpost.com",".adsizewrapper"],["nationalpost.com",".adsizewrapper"],["ottawasun.com",".adsizewrapper"],["theprovince.com",".adsizewrapper"],["torontosun.com",".adsizewrapper"],["winnipegsun.com",".adsizewrapper"],["forbes.it",".ad-row"],["warszawawpigulce.pl",".code-block-5, .eklama, #undermenu-block, .code-block-6"],["go.com",".has-ad"],["riderplanet-usa.com","#ad_1"],["nypost.com",".recirc"],["pagesix.com",".recirc"],["kzstock.blogspot.com","#ad-target"],["calgaryherald.com",".local-branding"],["queerpride.de",".category-advertorial"],["japan-webike.*",".ad_box\n.ad_title"],["webike.*",".ad_box\n.ad_title"],["webike-china.cn",".ad_box\n.ad_title"],["motherless.com",".media-linked"],["indoxx1.center",".lazy"],["pcgamer.com",".hawk-widget"],["washingtonpost.com",".pb-md.pt-md"],["order-order.com",".tag-sponsored"],["getcoloringpages.com",".adsBlock"],["saltspringexchange.com",".single-ad"],["hubblespacetelescope.blogspot.com",".vertical-ads"],["eslint.org",".sponsor-link"],["hwupgrade.it",".wrapper-xyz"],["brewerfanatic.com",".adthrive\n.adthrive-video-player"],["fishonfirst.com",".adthrive\n.adthrive-video-player"],["northsidebaseball.com",".adthrive\n.adthrive-video-player"],["twinsdaily.com",".adthrive\n.adthrive-video-player"],["damndelicious.net",".adthrive\n.adthrive-video-player"],["mediaite.com",".adthrive-video-player"],["player.tubia.com",".companion-ads"],["druckerchannel.de","#DCGA_CONTAINER"],["formulapassion.it","#qc-cmp2-main\n.qc-cmp2-main"],["xunta.gal","#anuncio"],["chavesnamao.com.br","#anuncio"],["dip-badajoz.es","#anuncio"],["gumtree.com.au",".header--is-new-sticky-behaviour\n.ad-cnt"],["sports.yahoo.com",".H\\(400px\\) > .VideoPlayer\n.H\\(400px\\).Pos\\(r\\)"],["shiropro-re.net","#ad_link"],["united.no",".page-ads"],["si.com",".is-below-header-ad"],["tamin.ir",".ads2"],["thequint.com","._4xQrn"],["dpp.org.tw",".ad_url"],["nybooks.com",".top-ad-wrapper"],["filecrypt.co","form > .protection.online ul > li:not(.buttons):has(> div:not(.circle_captcha))"],["lemonde.fr",".gdpr-lmd-wall"],["wnynewsnow.com",".ez-video-wrap"],["rpgbot.net",".ez-video-wrap"],["app.kultivi.com",".cnx-player-wrapper"],["hollywoodreporter.com",".cnx-player-wrapper"],["huffpost.com",".cnx-player-wrapper"],["sacbee.com",".cnx-player-wrapper"],["sport-fm.gr",".cnx-player-wrapper"],["sport24.gr",".cnx-player-wrapper"],["tvline.com",".cnx-player-wrapper"],["w3schools.com",".cnx-player-wrapper"],["deadline.com",".cnx-player-wrapper"],["hornoxe.com","div.post:has(a[href^=\"https://www.amazon.de/\"])"],["doodle.com",".AdsSlot\n.AdsLayout"],["ewrc-models.com",".cardAd"],["ewrc-results.com",".cardAd"],["delta.com",".adv-container"],["vindobona.org",".ads_footer"],["mytempsms.com","#container-ad"],["ewybory.eu",".advertisment"],["instapundit.com",".postad\n.ad-space:not(.adbox, .adsbox, .textads)"],["meijer.com",".product-grid__product:has(.product-tile__sponsored)"],["msn.com",".intra-article-module"],["helpster.de","#ad_sidebar_left_container"],["vuejs.org","#special-sponsor"],["saveinsta.cam",".aplvideo"],["spotifydown.com",".semi-transparent"],["outletarredamento.it",".ad-link:not(.adsbox)"],["spartanien.de",".firstload"],["pgportal.gov.in",".ad_image"],["scan-manga.com","#carouselTOPContainer"],["usmagazine.com",".ami-video-placeholder"],["hindustantimes.com",".rgtAdSection"],["bild.de","#fullBanner\n#powerplace\n#subchannelBanner1_1\n#subchannelBanner2_2\n.cbErotikContentbar15\n.contentbar\n.eyecatcher\n.footerbar\n.jetzt_aufnehmen\n.servicelinks\n.tea-rectangle\n.txe\n.yield\n.rectangle\n.fullbanner"],["sankakucomplex.com",".scad"],["bestgames.com","#adsContainer"],["yiv.com","#adsContainer"],["empflix.com","#hideAd"],["offmoto.com",".reklama:not(.ads)"],["freeopenvpn.org","#advert_top"],["spiegel.de",".asset-affiliatebox\n.nativead\n.nativead + .headline-date"],["hdblog.it",".item_compra\n.box_flame\n.box_grampa_shadow"],["speedtest.net",".pure-u-custom-ad-skyscraper"],["mcoc-guide.com","ins.adsbygoogle[data-ad-client]"],["safe.elektroupdate.com","ins.adsbygoogle[data-ad-client]"],["tamrieltradecentre.com","ins.adsbygoogle[data-ad-client]"],["play.aidungeon.io","ins.adsbygoogle[data-ad-client]"],["hilites.today","ins.adsbygoogle[data-ad-client]"],["karvitt.com","ins.adsbygoogle[data-ad-client]"],["maps4heroes.com","ins.adsbygoogle[data-ad-client]"],["estudyme.com","ins.adsbygoogle[data-ad-client]"],["fplstatistics.co.uk","ins.adsbygoogle[data-ad-client]"],["dexterclearance.com","ins.adsbygoogle[data-ad-client]"],["onlineatlas.us","ins.adsbygoogle[data-ad-client]"],["search.crowdsearch.net","#adslot1"],["iwin.com","#sponsorText"],["readmng.com",".scroll_target_top"],["fuqer.com",".spot-thumbs > .right"],["jameeltips.us",".banner-728x90"],["bestcash2020.com",".banner-728x90\n.banner-468x60"],["adcrypto.net",".adb-top"],["admediaflex.com",".adb-top"],["aduzz.com",".adb-top"],["bitcrypto.info",".adb-top"],["cdrab.com",".adb-top"],["datacheap.io",".adb-top"],["hbz.us",".adb-top"],["savego.org",".adb-top"],["owsafe.com",".adb-top"],["sportweb.info",".adb-top"],["bitzite.com",".banner-ad"],["cinedesi.in",".quads-location"],["thevouz.in",".quads-location"],["tejtime24.com",".quads-location"],["techishant.in",".quads-location"],["aman-dn.blogspot.com",".ads-ad"],["kiaclub.cz",".adwords"],["infogenyus.top",".ad-unit:not(.adsbox, .text-ad, .textads):not([style^=\"width: 1px; height: 1px; position: absolute;\"])"],["saboroso.blog",".ad-unit:not(.adsbox, .text-ad, .textads):not([style^=\"width: 1px; height: 1px; position: absolute;\"])"],["lamire.jp",".ad-unit:not(.adsbox, .text-ad, .textads):not([style^=\"width: 1px; height: 1px; position: absolute;\"])"],["tinhte.vn",".ad-unit:not(.adsbox, .text-ad, .textads):not([style^=\"width: 1px; height: 1px; position: absolute;\"])"],["tranimeizle.*",".video-ad-container"],["adblockstreamtape.*",".google-ad"],["adblockstrtape.*",".google-ad"],["adblockstrtech.*",".google-ad"],["antiadtape.*",".google-ad"],["stape.*",".google-ad"],["strcloud.*",".google-ad"],["streamtape.*",".google-ad"],["streamta.*",".google-ad"],["strtape.*",".google-ad"],["strtpe.*",".google-ad"],["strtapeadblock.*",".google-ad"],["advertisertape.com",".skyscraper.ad"],["tapeadsenjoyer.com",".skyscraper.ad"],["tapeadvertisement.com",".skyscraper.ad"],["tapeantiads.com",".skyscraper.ad"],["tapelovesads.org",".skyscraper.ad"],["tapenoads.com",".skyscraper.ad"],["watchadsontape.com",".skyscraper.ad"],["addictinggames.com",".ad_container\n.add-bx"],["comidoc.net",".googlead"],["winaero.com",".entry-content > div > div"],["porntn.com",".banner_ad"],["ads.snapchat.com",".banner_ad"],["neos-easygames.com","#ad_block"],["synk-casualgames.com","#ad_block"],["meetdownload.com",".ad-slot:not(.adsbox):not(.adsbygoogle)"],["waploaded.com",".ad-slot:not(.adsbox):not(.adsbygoogle)"],["plutomovies.com",".ad-slot:not(.adsbox):not(.adsbygoogle)"],["zunda.site","#ad_box:not([style^=\"position: absolute; left: -5000px\"])"],["musmus.main.jp","#ad_space:not([style^=\"position: absolute; left: -5000px\"])"],["streetinsider.com","#ad_space:not([style^=\"position: absolute; left: -5000px\"])"],["freehostbox.net","#adframe:not(frameset):not([style^=\"position: absolute; left: -5000px\"])"],["hatenablog.com","#adframe:not(frameset):not([style^=\"position: absolute; left: -5000px\"])"],["puzzle-ch.com","#adframe:not(frameset):not([style^=\"position: absolute; left: -5000px\"])"],["ma-bank.net","#adspace:not([style^=\"position: absolute; left: -5000px\"])"],["rxlife.net","#adspace:not([style^=\"position: absolute; left: -5000px\"])"],["video.tv-tokyo.co.jp","#adspace:not([style^=\"position: absolute; left: -5000px\"])"],["mmiyue.com",".google-ad:not(.testAd)"],["apkmirror.com",".adslot:not(.text-ad)\n.gooWidget\n.google-ad-leaderboard"],["tuxpi.com",".adslot:not(.text-ad)"],["h-flash.com",".google-ads"],["rakuten.com",".google-ads"],["ads.flytant.com",".google-ads"],["surfline.com",".ad-box:not(#ad-banner):not(:empty)"],["galaxyfirmware.*",".textad"],["jav68.net",".ads-header"],["kentonline.co.uk",".mpu"],["backcar.fr",".ad-content:not(:empty)"],["flat-ads.com",".ad-content:not(:empty)"],["job.inshokuten.com",".ad-content:not(:empty)"],["kontol.in",".ad-content:not(:empty)"],["tumblr.com",".Yc2Sp\n.Qrht9"],["viefaucet.com",".ad-description"],["kunststoffe.de",".adBox"],["windowspro.de","#block-views-sponsoredpromo-block"],["zeperfs.com",".showAd"],["sportnews.to",".ads-by-google"],["javgg.co","#AD_160"],["javgg.net","#AD_160"],["nieru.net",".ad-space:not(.adbox, .adsbox, .textads)"],["money.pl","#app > div[class^=\"sc-\"] > div[class]:not([class*=\" \"]):has(:scope > div[class*=\" \"]:only-child > img[src^=\"https://v.wpimg.pl/\"][src$=\"==\"][alt])"],["abczdrowie.pl",".article__textbox"],["pogoda.wp.pl",".desktop > div[class*=\" \"]:has(div)"],["winscreener.live",".ad-block"],["reshare.pm",".showads"],["phineypet.com","#adsiframe"],["tobys.dk",".abMessage"],["history.com",".m-header-ad\n.m-in-content-ad-row"],["crictracker.com",".ads-box"],["bing.com",".b_ad\n.b_adLastChild\n.pa_sb"],["pesmodding.com",".button-ad"],["ripleyfieldworktracker.com",".googleAds"],["decrypt.day","div[class*=\"content\"] center.w-full"],["uploadmall.com",".AdSense\n.advblock"],["app.involve.asia",".ads-banner"],["omuzaani.me",".Ad-Container:not(.adsbygoogle)"],["strikeout.im",".Ad-Container:not(.adsbygoogle)"],["wavewalt.me",".Ad-Container:not(.adsbygoogle)"],["fapeza.com",".azz_div"],["smashkarts.io","#AdBanner\n#Adbanner"],["sextb.*",".ad-placeholder:not(#detect, #detect_ad_empire, #filter_ads_by_classname, .adsbox)"],["best-hit.tv","#gStickyAd"],["majorgeeks.com",".navigation-light"],["pornohexen.com","#adsbox"]];

if ( genericSelectorMap ) {
    const map = self.genericSelectorMap =
        self.genericSelectorMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericSelectorMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before},\n${entry[1]}`);
            }
        }
    } else {
        self.genericSelectorMap = new Map(genericSelectorMap);
    }
    genericSelectorMap.length = 0;
}

if ( genericExceptionSieve ) {
    const hashes = self.genericExceptionSieve =
        self.genericExceptionSieve || new Set();
    if ( hashes.size !== 0 ) {
        for ( const hash of genericExceptionSieve ) {
            hashes.add(hash);
        }
    } else {
        self.genericExceptionSieve = new Set(genericExceptionSieve);
    }
    genericExceptionSieve.length = 0;
}

if ( genericExceptionMap ) {
    const map = self.genericExceptionMap =
        self.genericExceptionMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericExceptionMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before}\n${entry[1]}`);
            }
        }
    } else {
        self.genericExceptionMap = new Map(genericExceptionMap);
    }
    genericExceptionMap.length = 0;
}

/******************************************************************************/

})();

/******************************************************************************/
