/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

// ukr-0

// Important!
// Isolate from global scope
(function uBOL_cssGenericImport() {

/******************************************************************************/

const genericSelectorMap = [[2510,"#psyduckpockeball,\nnoindex > .cb_vda_container"],[2728,".mywidget__col > a.mywidget__link_advert"],[3240,".adfox_placeholder"],[3527,".text-center.adf-ins"],[3617,".ipsAdvertisement"],[941,".adv-news-within"],[1293,"body #vid_vpaut_div,\n.bannerRight"],[3494,".adsbyyottos,\n#icq_place"],[3121,".flat_pm_outgoing"],[3351,"#Ad2"],[1853,"#AdText"],[4052,"#Ad_Top"],[1145,"#Adfox_Banner,\n.bannerfootbox"],[3740,"#AdvertFieldBottom,\n.b-banner_slide"],[4060,"#AdvertFieldCenter"],[3392,"#AdvertFieldTop"],[3478,"#Advertisement,\n#BannerGBottom"],[3156,"#AdvertisingTopLine"],[2642,"#BanHolder28-1,\n.adtable"],[2353,"#BannerDiv"],[899,"#BannerGCenter"],[2186,"#BannerGIMG,\n.advert-horizontal"],[2216,"#BannerGTop"],[1988,"#BannerH2Left"],[2213,"#BannerHIMG"],[1688,"#BannerHLeft"],[2999,"#BannerUnderBroChat"],[2288,"#JaboxAdBarOuter"],[1374,"#JobInformer"],[3378,"#METABAR_IFRAME"],[1102,"#MarketGidComposite1001"],[60,"#PopUpWnd"],[2938,"#PopWin"],[2374,"#PopWin_popupsu_notds"],[1172,"#RichBanner_center"],[485,"#Tadspacehead,\n.mpu"],[2337,"#__adIframe"],[159,"#ad-200"],[2740,"#ad-container,\n.ad468"],[1392,"#ad-content"],[1565,"#ad-slides"],[4066,"#ad-wrapper"],[3636,"#ad1"],[3639,"#ad2"],[3638,"#ad3"],[3633,"#ad4"],[3634,"#ad7"],[3618,"#ad728x90"],[857,"#adContainer"],[1678,"#adHeadBanner"],[3657,"#adL"],[3669,"#adP"],[3176,"#adTop"],[959,"#adWrapper"],[3014,"#ad_container,\n#bannerlayer"],[422,"#ad_help_link,\n.b-vacancy-bannerplace"],[3071,"#ad_hide_mask_ad_0,\n#ad_hide_mask_ad_1,\n.r_banner"],[3777,"#ad_square"],[3088,"#ad_wrapper"],[252,"#adbns,\n.b-ad-block-vertical"],[2867,"#adf_notifiers_wrap"],[2722,"#adposition3"],[2323,"#adriver_banner"],[3792,"#adsCSS"],[1605,"#adspace"],[3697,"#adt"],[228,"#advRightBox"],[2257,"#advblock"],[1211,"#advbroker_place_1,\n#advbroker_place_2,\n#advbroker_place_3,\n#advbroker_place_4,\n#advbroker_place_5,\n#advbroker_place_6,\n#advbroker_place_7,\n#advbroker_place_8,\n#advbroker_place_9"],[4088,"#advbroker_place_10"],[3765,"#advertbox"],[3459,"#advertise"],[3510,"#advertisement"],[1674,"#advertising"],[3814,"#advertising_floater"],[519,"#adverts,\n.banners_list"],[455,"#advrich"],[2129,"#advunder-top"],[1140,"#adzerk3"],[3779,"#app-banners"],[1408,"#b_top-banner"],[3438,"#ban_zone_4,\n.marketgidVr"],[1109,"#banerHead"],[1248,"#banner-container"],[1935,"#banner-container-240x400,\n.banner-border-wrap"],[2373,"#banner-header-bottom"],[957,"#banner-placeholder"],[3362,"#banner-top"],[2889,"#banner-top-2,\n#banner-top-3,\n#banner-top-4"],[174,"#banner-wrap"],[3745,"#banner240"],[1798,"#banner300_250"],[3012,"#banner3_wraper"],[818,"#banner_2"],[976,"#banner_box,\n#banner_top"],[1804,"#banner_column"],[914,"#banner_container"],[903,"#banner_container_bayru"],[286,"#banner_container_ch"],[982,"#banner_div"],[2815,"#banner_head"],[3157,"#banner_journals"],[1715,"#banner_notes"],[3578,"#banner_place_1_wrap"],[1660,"#banner_title"],[2403,"#banner_top2"],[3349,"#banners-for-study"],[558,"#banners_bottom"],[2047,"#banners_left"],[3445,"#banners_right,\n.h-footer-banner"],[1524,"#banners_rot,\n.tzrlnd_td"],[2851,"#banners_rot_block"],[2673,"#bannner_header"],[2088,"#bbccom_mpu"],[1087,"#bbccom_storyprintsponsorship"],[2244,"#bg_banner_l"],[2266,"#bg_banner_r"],[3908,"#bl_top_reklama"],[2487,"#bl_top_reklama2"],[1828,"#bottom-banners"],[3757,"#bottomBanners"],[1309,"#bottom_advert"],[3909,"#bottom_commercial"],[1428,"#branding_block"],[1412,"#branding_flash,\n#mailru_game_leftclicks"],[2971,"#brandtop"],[3668,"#breklama"],[2200,"#buttonad"],[1906,"#contentAd"],[1556,"#content_ad"],[614,"#cpa-system-banner"],[1646,"#ctl00_Main3_bannerDiv"],[962,"#ctl00_abot_bb"],[980,"#ctl00_atop_bt"],[96,"#ctnAdsRight"],[1456,"#divFlashTeaser"],[2645,"#dle-content #lp-block-1,\n#dle-content #sip22,\n#dle-content .cb_dav_container,\n#dle-content .download_inner,\n#dle-content .mad22-search,\n#dle-content .modul-sp_main,\n#dle-content .search_result,\n#dle-content > #down-up,\n#dle-content > noindex > span,\n#dle-content noindex > div.central,\n#dle-content noindex > table[style]"],[3367,"#explosive_banner_1240"],[706,"#f_advert"],[2041,"#featuread"],[2806,"#floating_banner_bottom"],[3902,"#footer_ads"],[4003,"#from_our_sponsors"],[1538,"#gad"],[489,"#google_ads_frame1"],[3319,"#googleadbox"],[2596,"#head-ad"],[3505,"#head-banner"],[3421,"#header_ad"],[0,"#header_banner"],[4012,"#informers-168"],[928,"#isviVideoBlock"],[3251,"#jobukrnet"],[409,"#leader-sponsor"],[290,"#left_ban"],[556,"#left_ban2"],[1693,"#left_ban_micro"],[3294,"#left_reklama"],[3512,"#leftbanners"],[3752,"#lt-topbanner"],[3730,"#mailru_game_righgtclicks,\n#partnerIframe"],[3794,"#mediaget_box"],[744,"#mpu"],[1075,"#n_Ad"],[1402,"#nolix"],[236,"#player_ads_block,\n.ad-block-240x400"],[2196,"#poptrafWin"],[2909,"#preS_BANNERID"],[3774,"#preS_BANNERID2"],[2118,"#premium-banner-1,\n#premium-banner-2"],[428,"#printads"],[3593,"#promo > div.box,\n#promo > div.t_box,\nnoindex > div#promo"],[3756,"#promo-ad"],[2086,"#promo_bottom > div.box,\n#promo_bottom > div.t_box,\nnoindex > div#promo_bottom"],[3921,"#qcash-extended-block"],[274,"#r_banner,\n.sponsor_horizontal"],[798,"#rekblock"],[2423,"#rekl"],[343,"#reklamblok-2,\n.adElement"],[135,"#right-banner"],[2312,"#right-banner-2"],[267,"#rightS_BANNERID"],[2166,"#right_reklama"],[1299,"#rightbanners"],[1869,"#rotating_banners"],[2669,"#sape_style"],[881,"#sapetext,\n.msk-onair-advert-block"],[2137,"#section-sponsors"],[4067,"#showad"],[284,"#showcase_links"],[355,"#showcase_links_beg"],[356,"#showcase_links_end"],[1673,"#showcase_posters"],[978,"#showcase_posters_beg"],[985,"#showcase_posters_end"],[157,"#sidebar_ads"],[1379,"#skyscraperad"],[1357,"#slon_partner_widget"],[2336,"#smart_banner"],[3876,"#sp22"],[2356,"#splinks"],[1772,"#spons_left"],[2113,"#sponsor-search"],[1596,"#sponsor_panSponsor"],[1991,"#sponsor_recommendations"],[1968,"#sponsoradd"],[1973,"#sponsorbar,\n.block_ad"],[1979,"#sponsorbox,\n.adBox"],[3795,"#sponsored"],[1125,"#sponsored-ads"],[1413,"#teaser_block_div"],[2979,"#teasers"],[1783,"#teasers-sidebarleft"],[2351,"#teasers-top"],[2161,"#tizerclik"],[312,"#tizeri_vnizu"],[304,"#top-advert-block"],[99,"#top-advert-block-second"],[1845,"#topBannerAd"],[1108,"#top_ad"],[1156,"#top_banner"],[310,"#top_banners"],[2536,"#topad"],[2712,"#topads"],[16,"#topbanners"],[2720,"#toplogo_banner"],[3307,"#tpl_vertbanner_block"],[1336,"#trans_ad_box"],[3174,"#vBanner,\n.postads-bw-bkg2"],[2819,"#vi_ad"],[4085,"#viboom"],[3154,"#videoPageAds,\n.centerBttmBann"],[3586,"#vkMsg"],[1341,"#widget_floatbanner"],[2422,"#wsllc_rotator"],[34,"#yahoo_ads_2010"],[3954,"#zm_banner"],[2011,".AdBox"],[1187,".AdInfo,\n.adinfo"],[3148,".AdTitle"],[3640,".Advert"],[3596,".Banner240,\n.Banner240 > a,\n.Banner240 > img,\n.Banner240 > object"],[3561,".Banner710,\n.Banner710 > a,\n.Banner710 > img,\n.Banner710 > object,\n.Banner780,\n.Banner780 > a,\n.Banner780 > img,\n.Banner780 > object"],[868,".BannerKnopka"],[1015,".BannerKnopka2"],[618,".BannerTop"],[2989,".BannerVertMargin7"],[3525,".MPU"],[1980,".SponsorCFrame"],[2628,".ad-button"],[3091,".ad-sputnik-wrapper"],[2572,".ad21"],[3892,".adContainer"],[3957,".adDiv"],[3483,".adHolder"],[3161,".adModule"],[3968,".adSummary"],[1072,".adText"],[3116,".adTitle"],[2866,".adWrapper"],[1692,".ad_Right"],[131,".ad_body"],[776,".ad_left"],[970,".ad_left_block"],[3023,".ad_links"],[1916,".ad_right"],[952,".ad_space"],[2824,".ad_top_panel"],[10,".adbg,\n.bannerBlock"],[839,".adblockcenter"],[3733,".addiv,\n.bc_adv_container_2,\n.bc_adv_container_3"],[2001,".adframe"],[2967,".adhere"],[1010,".adhered,\n.b-section_banners,\n.banner-square"],[2491,".adholder"],[609,".adi"],[2454,".adleft"],[3567,".adlist"],[3073,".admarker"],[916,".adpic"],[1025,".adprice"],[3532,".adright"],[462,".ads739x90"],[1741,".ads_ban,\n.rek_table"],[404,".adsenseblock"],[544,".adv-post"],[46,".advBrand"],[3562,".adv_bl"],[885,".adv_to_hide_holder"],[3667,".advert__banner"],[2946,".advert_list"],[1645,".advertiser"],[3053,".advertisment"],[2172,".advertka"],[2506,".adverts,\n.banner-link-right"],[1874,".adwrapper"],[1608,".affiliate"],[1616,".ah-teaser-wrapper"],[206,".ammblock"],[2331,".appgrade_banners"],[3149,".appwidget-journalpromo"],[3661,".artbannersplus"],[2680,".b-ad-rightBanner"],[3097,".b-advert"],[2783,".b-app-banner-list"],[3573,".b-article-aside__banner"],[861,".b-banner"],[196,".b-banner-240x400"],[4089,".b-branding__flash"],[2800,".b-hbanner"],[1041,".b-journalpromo-container"],[2114,".b-resizable-ads-area"],[3564,".b-revolver-bann"],[2022,".b-side-banner"],[178,".b-slando"],[97,".b-tbl_banner_links"],[86,".b-tizer"],[3477,".b-wrap_banner"],[379,".bDown"],[3359,".bFiles"],[3821,".b_top-banner"],[29,".ban-border"],[338,".ban250"],[3292,".ban468b"],[3273,".ban468w"],[2781,".baner_block"],[1151,".banex-banner"],[3126,".banfoot,\n.sponsorTop,\n.sponsorbox"],[672,".banner-head"],[1130,".banner-hold"],[1330,".banner-link-left"],[1699,".banner-link-top"],[2345,".banner-mid"],[1865,".banner-place"],[45,".banner-r"],[813,".banner-side"],[1603,".banner-top-film"],[2569,".banner-work-in"],[3628,".banner240"],[1240,".banner240_10"],[921,".banner2_right"],[168,".banner300x100"],[203,".banner300x250"],[3496,".banner640"],[3416,".bannerPlace"],[2089,".bannerTipe"],[2634,".bannerTop"],[3722,".banner_240x400"],[39,".banner_bg_bottom_link"],[2697,".banner_bg_top_link"],[1910,".banner_center"],[400,".banner_panel"],[571,".banner_place"],[712,".banner_topss"],[234,".bannerblock"],[3446,".bannerflash23"],[452,".bannerhead,\n.rastyazka"],[2037,".bannerin"],[4059,".banners-top"],[1136,".banners1"],[1139,".banners2"],[1642,".bannertop"],[3566,".banwth"],[607,".bbanner"],[3479,".bc-adv"],[165,".bc_adv"],[1519,".bc_adv_container"],[2493,".bc_adv_i"],[3192,".bc_adv_inside_container"],[3879,".bloc_rek"],[107,".blockadwide"],[3913,".bnr_r2"],[3973,".bottom_ad_block"],[1656,".bottom_banner"],[2450,".bottombanner"],[1270,".carambis_hbanner_336"],[2716,".cb_avd_container"],[1361,".cb_footer_sponsor"],[2667,".cb_vad_container"],[3177,".clips-adv"],[2236,".cnnMosaic160Container"],[1663,".contentAd"],[3462,".contentadcontainer"],[4002,".contextBanner"],[724,".diet-banner"],[1222,".dircash_button"],[837,".div_reklamma"],[3965,".firmach_form_rifform"],[1728,".fixed-reklama"],[3180,".flat_ads_block"],[2981,".h_banner"],[1877,".hbanner"],[937,".head-ad"],[498,".header-advertisement"],[188,".headerAd"],[1505,".header_ad_center"],[3646,".homep_banner"],[3383,".horizontal_ad"],[3847,".ig_banners_container"],[714,".ins_banner-part"],[3231,".left-banner"],[2066,".leftBanns"],[1217,".left_ads_block"],[3045,".left_back_banner2"],[1276,".left_bnr"],[2436,".logo_advert"],[2685,".marketgidV"],[3476,".mediaget"],[1810,".mid_ad"],[3344,".middleads"],[2136,".mobile-sponsoring"],[4008,".mod22-search"],[3652,".mod_banner"],[2816,".modul-one-search"],[4022,".modul-search"],[1867,".module-ad"],[2185,".module-one-search"],[2950,".mpuHolder"],[3255,".ms_inside_block"],[1203,".msk-banner-block"],[4091,".mywidget-content-ad"],[991,".one-search"],[1224,".one-search6"],[2226,".oteaser"],[3426,".pbaner"],[963,".post_inner_banner"],[931,".premium_adv"],[2807,".publicidad"],[3559,".q_teaser_wrapper"],[1635,".qc-one-search"],[4086,".qc_search"],[2320,".rebrand_clickable"],[2556,".reclama"],[1184,".reclama_v"],[3098,".rekl"],[2062,".rekl5"],[3919,".reklama123"],[2363,".reklamapolos"],[1506,".results_sponsor"],[3851,".right_back_banner2"],[3523,".right_banner_premium"],[1135,".rightrecl"],[2648,".rkl"],[2996,".s_adv"],[2991,".skyad"],[323,".slidebar-banner-block"],[737,".sp_one_search"],[3522,".sp_one_search1,\n.sp_one_search2,\n.sp_one_search3"],[4084,".sp_search"],[1687,".sp_search2,\n.sp_search3"],[2497,".sp_search_table"],[3644,".sponsor-top,\n.sponsor_top"],[3150,".sponsoredtextlink_container"],[423,".statcounter"],[1602,".subs-top-banner"],[3881,".surbis_banner"],[3849,".teasers_horizontal"],[855,".tizerblock"],[3259,".top-sponsors"],[3394,".top-teasers"],[261,".topAd"],[2659,".topBannerMainPage"],[3261,".topBanns"],[2122,".top_ad2"],[1243,".top_banners"],[2343,".top_megabanner"],[1509,".topad"],[2653,".topbanner2"],[731,".topbannerbg"],[426,".tpl_bottom_banners"],[2237,".videoAd"],[2020,".visitweb_block"],[190,"div.article-content-full-inner > div[onmouseover]"],[1623,"div.bannerbg"],[3063,"div.topbaner"],[3575,"noindex .download_btn"],[3041,"noindex > .d-link"],[1972,"noindex > div#promo2_bottom2"],[2264,"noindex > div.down"],[114,"noindex > div.download"],[1577,"noindex > div.search_result"]];
const genericExceptionSieve = [1374,485,2740,3636,3638,3618,857,3176,3014,3088,2722,2323,1605,2257,3459,3510,1674,519,174,914,1906,1556,2041,3902,2596,3421,3794,428,3756,157,3795,2979,1845,1108,310,2011,1187,3148,3640,618,2628,1979,3892,3957,343,3483,3968,1072,3116,1692,131,3023,1916,952,3733,2001,2491,609,2454,3567,916,2642,3053,1874,3097,3573,861,1973,3973,2450,1663,188,3383,3476,1810,1867,3098,1509,3575,1719,3336,236,3757,991,1010,293];
const genericExceptionMap = [["ukr.net","#JobInformer"],["kids.t-online.de","#Tadspacehead"],["madame.lefigaro.fr","#ad-container"],["tphousing.com","#ad1"],["absoluteradio.co.uk","#ad3"],["natgeo.tv","#ad728x90"],["jobs.wa.gov.au","#adContainer"],["pricewatch.com","#adContainer"],["ran.de","#adTop"],["academics.de","#ad_container"],["amnestyusa.org","#ad_wrapper"],["drownedinsound.com","#ad_wrapper"],["mercurynews.com","#adposition3\n.adElement"],["siliconvalley.com","#adposition3\n.adElement"],["fotonews.join.ua","#adriver_banner"],["join.ua","#adriver_banner"],["metblogs.com","#adspace"],["oreilly.com","#adspace"],["mobile-review.com","#advblock"],["zlatestranky.cz","#advertise"],["ping-timeout.de","#advertisement"],["letidor.ru","#advertising"],["uscbookstore.com","#advertising"],["markt.de","#adverts"],["flickr.com","#banner-wrap\n#promo-ad"],["airpano.com","#banner_container"],["airpano.ru","#banner_container"],["filecheck.ru","#contentAd"],["maximonline.ru","#content_ad"],["discuss.com.hk","#featuread"],["uwants.com","#featuread"],["investopedia.com","#footer_ads"],["uwcu.org","#head-ad"],["cmt.com","#header_ad"],["mediaget.com","#mediaget_box\n.mediaget"],["bipbip.co.il","#printads\n.adText\n.adlist\n.adpic"],["facebook.com","#sidebar_ads"],["japantoday.com","#sidebar_ads"],["worldsbestbars.com","#sponsored"],["hm.com","#teasers"],["neowin.net","#topBannerAd"],["morningstar.se","#top_ad"],["trusted.ru","#top_banners"],["co-operative.coop",".AdBox"],["backpage.com",".AdInfo\n.adinfo"],["superbikeplanet.com",".AdTitle\n.adDiv\n.adTitle\n.addiv"],["ph4.ru",".Advert"],["swanseacity.net",".Advert"],["wrexhamafc.co.uk",".Advert"],["love.mail.ru",".BannerTop"],["mamba.ru",".BannerTop"],["assetbar.com",".ad-button"],["itavisen.no",".ad468"],["ksl.com",".adBox\n.adTitle"],["mycareer.com.au",".adContainer"],["superhry.cz",".adHolder"],["marktplaats.nl",".adSummary"],["nirmaltv.com",".ad_Right"],["moyareklama.ru",".ad_body\n.ad_links"],["panarmenian.net",".ad_body"],["leboncoin.fr",".ad_links"],["subito.it",".ad_links"],["didaktik-der-mathematik.de",".ad_right"],["chinapost.com.tw",".ad_space"],["linux.com",".adframe"],["northjersey.com",".adholder"],["epey.com",".adi"],["hotrod.com",".adleft"],["superchevy.com",".adleft"],["hgh14x.com",".adlist"],["quoka.de",".adpic"],["rinkworks.com",".adtable"],["macwelt.de",".advertisment"],["redmondpie.com",".advertisment"],["calgaryherald.com",".adwrapper"],["montrealgazette.com",".adwrapper"],["vancouversun.com",".adwrapper"],["windsorstar.com",".adwrapper"],["irr.by",".b-advert"],["news.rambler.ru",".b-article-aside__banner"],["esetnod32.ru",".b-banner"],["bigtracker.ru",".block_ad"],["ixbtlabs.com",".bottom_ad_block"],["filmz.ru",".bottombanner"],["theology.edu",".contentAd"],["photobucket.com",".headerAd"],["radaronline.com",".horizontal_ad"],["driver.ru",".mid_ad"],["corrieredicomo.it",".module-ad"],["dolinacharlotty.pl",".mpu"],["gamespot.com",".mpu"],["cheb.ru",".rekl"],["forum.zarulem.ws",".rekl"],["na-svyazi.ru",".rekl"],["pchome.com.tw",".topad"],["dropmefiles.com","noindex .download_btn"],["infopedia.su",".adbanner"],["studopedia.net",".adbanner"],["studopedia.su",".adbanner"],["studopedia.org",".adbanner"],["studopedia.ru",".adbanner"],["studopedia.com.ua",".adbanner"],["lektsii.org",".adbanner"],["mydocx.ru",".adbanner"],["ictv.ua","#adblock"],["tubator.com","#player_ads_block"],["oztech.ru","#bottomBanners"],["lib.seu.edu.cn",".one-search"],["eplus.kiev.ua",".banner-square"],["texts.com.ua",".topAD"]];

if ( genericSelectorMap ) {
    const map = self.genericSelectorMap =
        self.genericSelectorMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericSelectorMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before},\n${entry[1]}`);
            }
        }
    } else {
        self.genericSelectorMap = new Map(genericSelectorMap);
    }
    genericSelectorMap.length = 0;
}

if ( genericExceptionSieve ) {
    const hashes = self.genericExceptionSieve =
        self.genericExceptionSieve || new Set();
    if ( hashes.size !== 0 ) {
        for ( const hash of genericExceptionSieve ) {
            hashes.add(hash);
        }
    } else {
        self.genericExceptionSieve = new Set(genericExceptionSieve);
    }
    genericExceptionSieve.length = 0;
}

if ( genericExceptionMap ) {
    const map = self.genericExceptionMap =
        self.genericExceptionMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericExceptionMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before}\n${entry[1]}`);
            }
        }
    } else {
        self.genericExceptionMap = new Map(genericExceptionMap);
    }
    genericExceptionMap.length = 0;
}

/******************************************************************************/

})();

/******************************************************************************/
