/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock

*/

// ruleset: ublock-filters

// Important!
// Isolate from global scope

// Start of local scope
(function uBOL_abortCurrentScript() {

/******************************************************************************/

function abortCurrentScript(...args) {
    runAtHtmlElementFn(( ) => {
        abortCurrentScriptFn(...args);
    });
}

function abortCurrentScriptFn(
    target = '',
    needle = '',
    context = ''
) {
    if ( typeof target !== 'string' ) { return; }
    if ( target === '' ) { return; }
    const safe = safeSelf();
    const logPrefix = safe.makeLogPrefix('abort-current-script', target, needle, context);
    const reNeedle = safe.patternToRegex(needle);
    const reContext = safe.patternToRegex(context);
    const extraArgs = safe.getExtraArgs(Array.from(arguments), 3);
    const thisScript = document.currentScript;
    const chain = safe.String_split.call(target, '.');
    let owner = window;
    let prop;
    for (;;) {
        prop = chain.shift();
        if ( chain.length === 0 ) { break; }
        if ( prop in owner === false ) { break; }
        owner = owner[prop];
        if ( owner instanceof Object === false ) { return; }
    }
    let value;
    let desc = Object.getOwnPropertyDescriptor(owner, prop);
    if (
        desc instanceof Object === false ||
        desc.get instanceof Function === false
    ) {
        value = owner[prop];
        desc = undefined;
    }
    const debug = shouldDebug(extraArgs);
    const exceptionToken = getExceptionTokenFn();
    const scriptTexts = new WeakMap();
    const textContentGetter = Object.getOwnPropertyDescriptor(Node.prototype, 'textContent').get;
    const getScriptText = elem => {
        let text = textContentGetter.call(elem);
        if ( text.trim() !== '' ) { return text; }
        if ( scriptTexts.has(elem) ) { return scriptTexts.get(elem); }
        const [ , mime, content ] =
            /^data:([^,]*),(.+)$/.exec(elem.src.trim()) ||
            [ '', '', '' ];
        try {
            switch ( true ) {
            case mime.endsWith(';base64'):
                text = self.atob(content);
                break;
            default:
                text = self.decodeURIComponent(content);
                break;
            }
        } catch {
        }
        scriptTexts.set(elem, text);
        return text;
    };
    const validate = ( ) => {
        const e = document.currentScript;
        if ( e instanceof HTMLScriptElement === false ) { return; }
        if ( e === thisScript ) { return; }
        if ( context !== '' && reContext.test(e.src) === false ) {
            // eslint-disable-next-line no-debugger
            if ( debug === 'nomatch' || debug === 'all' ) { debugger; }
            return;
        }
        if ( safe.logLevel > 1 && context !== '' ) {
            safe.uboLog(logPrefix, `Matched src\n${e.src}`);
        }
        const scriptText = getScriptText(e);
        if ( reNeedle.test(scriptText) === false ) {
            // eslint-disable-next-line no-debugger
            if ( debug === 'nomatch' || debug === 'all' ) { debugger; }
            return;
        }
        if ( safe.logLevel > 1 ) {
            safe.uboLog(logPrefix, `Matched text\n${scriptText}`);
        }
        // eslint-disable-next-line no-debugger
        if ( debug === 'match' || debug === 'all' ) { debugger; }
        safe.uboLog(logPrefix, 'Aborted');
        throw new ReferenceError(exceptionToken);
    };
    // eslint-disable-next-line no-debugger
    if ( debug === 'install' ) { debugger; }
    try {
        Object.defineProperty(owner, prop, {
            get: function() {
                validate();
                return desc instanceof Object
                    ? desc.get.call(owner)
                    : value;
            },
            set: function(a) {
                validate();
                if ( desc instanceof Object ) {
                    desc.set.call(owner, a);
                } else {
                    value = a;
                }
            }
        });
    } catch(ex) {
        safe.uboErr(logPrefix, `Error: ${ex}`);
    }
}

function runAtHtmlElementFn(fn) {
    if ( document.documentElement ) {
        fn();
        return;
    }
    const observer = new MutationObserver(( ) => {
        observer.disconnect();
        fn();
    });
    observer.observe(document, { childList: true });
}

function getExceptionTokenFn() {
    const token = getRandomTokenFn();
    const oe = self.onerror;
    self.onerror = function(msg, ...args) {
        if ( typeof msg === 'string' && msg.includes(token) ) { return true; }
        if ( oe instanceof Function ) {
            return oe.call(this, msg, ...args);
        }
    }.bind();
    return token;
}

function safeSelf() {
    if ( scriptletGlobals.safeSelf ) {
        return scriptletGlobals.safeSelf;
    }
    const self = globalThis;
    const safe = {
        'Array_from': Array.from,
        'Error': self.Error,
        'Function_toStringFn': self.Function.prototype.toString,
        'Function_toString': thisArg => safe.Function_toStringFn.call(thisArg),
        'Math_floor': Math.floor,
        'Math_max': Math.max,
        'Math_min': Math.min,
        'Math_random': Math.random,
        'Object': Object,
        'Object_defineProperty': Object.defineProperty.bind(Object),
        'Object_defineProperties': Object.defineProperties.bind(Object),
        'Object_fromEntries': Object.fromEntries.bind(Object),
        'Object_getOwnPropertyDescriptor': Object.getOwnPropertyDescriptor.bind(Object),
        'Object_hasOwn': Object.hasOwn.bind(Object),
        'RegExp': self.RegExp,
        'RegExp_test': self.RegExp.prototype.test,
        'RegExp_exec': self.RegExp.prototype.exec,
        'Request_clone': self.Request.prototype.clone,
        'String': self.String,
        'String_fromCharCode': String.fromCharCode,
        'String_split': String.prototype.split,
        'XMLHttpRequest': self.XMLHttpRequest,
        'addEventListener': self.EventTarget.prototype.addEventListener,
        'removeEventListener': self.EventTarget.prototype.removeEventListener,
        'fetch': self.fetch,
        'JSON': self.JSON,
        'JSON_parseFn': self.JSON.parse,
        'JSON_stringifyFn': self.JSON.stringify,
        'JSON_parse': (...args) => safe.JSON_parseFn.call(safe.JSON, ...args),
        'JSON_stringify': (...args) => safe.JSON_stringifyFn.call(safe.JSON, ...args),
        'log': console.log.bind(console),
        // Properties
        logLevel: 0,
        // Methods
        makeLogPrefix(...args) {
            return this.sendToLogger && `[${args.join(' \u205D ')}]` || '';
        },
        uboLog(...args) {
            if ( this.sendToLogger === undefined ) { return; }
            if ( args === undefined || args[0] === '' ) { return; }
            return this.sendToLogger('info', ...args);
            
        },
        uboErr(...args) {
            if ( this.sendToLogger === undefined ) { return; }
            if ( args === undefined || args[0] === '' ) { return; }
            return this.sendToLogger('error', ...args);
        },
        escapeRegexChars(s) {
            return s.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
        },
        initPattern(pattern, options = {}) {
            if ( pattern === '' ) {
                return { matchAll: true, expect: true };
            }
            const expect = (options.canNegate !== true || pattern.startsWith('!') === false);
            if ( expect === false ) {
                pattern = pattern.slice(1);
            }
            const match = /^\/(.+)\/([gimsu]*)$/.exec(pattern);
            if ( match !== null ) {
                return {
                    re: new this.RegExp(
                        match[1],
                        match[2] || options.flags
                    ),
                    expect,
                };
            }
            if ( options.flags !== undefined ) {
                return {
                    re: new this.RegExp(this.escapeRegexChars(pattern),
                        options.flags
                    ),
                    expect,
                };
            }
            return { pattern, expect };
        },
        testPattern(details, haystack) {
            if ( details.matchAll ) { return true; }
            if ( details.re ) {
                return this.RegExp_test.call(details.re, haystack) === details.expect;
            }
            return haystack.includes(details.pattern) === details.expect;
        },
        patternToRegex(pattern, flags = undefined, verbatim = false) {
            if ( pattern === '' ) { return /^/; }
            const match = /^\/(.+)\/([gimsu]*)$/.exec(pattern);
            if ( match === null ) {
                const reStr = this.escapeRegexChars(pattern);
                return new RegExp(verbatim ? `^${reStr}$` : reStr, flags);
            }
            try {
                return new RegExp(match[1], match[2] || undefined);
            }
            catch {
            }
            return /^/;
        },
        getExtraArgs(args, offset = 0) {
            const entries = args.slice(offset).reduce((out, v, i, a) => {
                if ( (i & 1) === 0 ) {
                    const rawValue = a[i+1];
                    const value = /^\d+$/.test(rawValue)
                        ? parseInt(rawValue, 10)
                        : rawValue;
                    out.push([ a[i], value ]);
                }
                return out;
            }, []);
            return this.Object_fromEntries(entries);
        },
        onIdle(fn, options) {
            if ( self.requestIdleCallback ) {
                return self.requestIdleCallback(fn, options);
            }
            return self.requestAnimationFrame(fn);
        },
        offIdle(id) {
            if ( self.requestIdleCallback ) {
                return self.cancelIdleCallback(id);
            }
            return self.cancelAnimationFrame(id);
        }
    };
    scriptletGlobals.safeSelf = safe;
    if ( scriptletGlobals.bcSecret === undefined ) { return safe; }
    // This is executed only when the logger is opened
    safe.logLevel = scriptletGlobals.logLevel || 1;
    let lastLogType = '';
    let lastLogText = '';
    let lastLogTime = 0;
    safe.toLogText = (type, ...args) => {
        if ( args.length === 0 ) { return; }
        const text = `[${document.location.hostname || document.location.href}]${args.join(' ')}`;
        if ( text === lastLogText && type === lastLogType ) {
            if ( (Date.now() - lastLogTime) < 5000 ) { return; }
        }
        lastLogType = type;
        lastLogText = text;
        lastLogTime = Date.now();
        return text;
    };
    try {
        const bc = new self.BroadcastChannel(scriptletGlobals.bcSecret);
        let bcBuffer = [];
        safe.sendToLogger = (type, ...args) => {
            const text = safe.toLogText(type, ...args);
            if ( text === undefined ) { return; }
            if ( bcBuffer === undefined ) {
                return bc.postMessage({ what: 'messageToLogger', type, text });
            }
            bcBuffer.push({ type, text });
        };
        bc.onmessage = ev => {
            const msg = ev.data;
            switch ( msg ) {
            case 'iamready!':
                if ( bcBuffer === undefined ) { break; }
                bcBuffer.forEach(({ type, text }) =>
                    bc.postMessage({ what: 'messageToLogger', type, text })
                );
                bcBuffer = undefined;
                break;
            case 'setScriptletLogLevelToOne':
                safe.logLevel = 1;
                break;
            case 'setScriptletLogLevelToTwo':
                safe.logLevel = 2;
                break;
            }
        };
        bc.postMessage('areyouready?');
    } catch {
        safe.sendToLogger = (type, ...args) => {
            const text = safe.toLogText(type, ...args);
            if ( text === undefined ) { return; }
            safe.log(`uBO ${text}`);
        };
    }
    return safe;
}

function shouldDebug(details) {
    if ( details instanceof Object === false ) { return false; }
    return scriptletGlobals.canDebug && details.debug;
}

function getRandomTokenFn() {
    const safe = safeSelf();
    return safe.String_fromCharCode(Date.now() % 26 + 97) +
        safe.Math_floor(safe.Math_random() * 982451653 + 982451653).toString(36);
}

/******************************************************************************/

const scriptletGlobals = {}; // eslint-disable-line
const argsList = [["globalThis","break;case"],["WebAssembly","atob"],["Math.random","parseInt(localStorage['\\x"],["Math","localStorage['\\x"],["KeenTracking"],["jQuery","cookie"],["showAds"],["open"],["$","_sp_._networkListenerData"],["document.querySelector","popupBlocked"],["Math","/\\}\\s*\\(.*?\\b(self|this|window)\\b.*?\\)/"],["setTimeout","admc"],["$","window.open"],["decodeURIComponent","shift"],["$","samInitDetection"],["decodeURI","decodeURIComponent"],["$","lobster"],["String.fromCharCode","shift"],["$","AdBlocker"],["addEventListener","displayMessage"],["document.createElement","admc"],["jQuery","TestAdBlock"],["document.getElementById","document.write"],["$","test-block"],["$","adi"],["$","undefined"],["onload","open"],["$","Adblock"],["ExoLoader"],["puShown","/doOpen|popundr/"],["$","serve"],["document.createElement","script"],["Math","XMLHttpRequest"],["$","ltvModal"],["pop3","window.open"],["jQuery","ready"],["setTimeout","1000"],["atob","decodeURIComponent"],["document.createElement","l.parentNode.insertBefore(s"],["__ADX_URL_U"],["atob","tabunder"],["RegExp","POSTBACK_PIXEL"],["document.getElementById","undefined"],["addEventListener","-0x"],["stop","adblock"],["document.querySelectorAll","popMagic"],["atob"],["ab1","ab2"],["jQuery","pp12"],["decodeURI","atob"],["jQuery","btoa"],["btoa","BOOTLOADER_LOADED"],["document.getElementsByTagName","onclick"],["awm","location"],["getCookie"],["__ads"],["setTimeout","____POP"],["is_noadblock","window.location"],["$","AdBlockUtil"],["$","show"],["setTimeout","document.querySelector"],["jQuery","document.cookie"],["document.getElementById","adblock"],["JSON.parse","atob"],["navigator","FingerprintJS"],["btoa"],["$","blockAds"],["onload","btoa"],["decodeURI","getScriptFromCss"],["document.getElementById","try"],["$","userAgent"],["document.getElementById","adblocker"],["azar","redirect"],["onload"],["$","azar"],["Math.floor","hilltop"],["$","vglnk"],["setTimeout","aadblock"],["addEventListener","document.createElement"],["readCookieDelit"],["atob","decodeURI"],["Object.defineProperty","trafficjunky"],["$","html"],["__htapop"],["blur"],["$","open"],["document.getElementById","testadblock"],["document.addEventListener","google_ad_client"],["document.getElementById","overlayBtn"],["document.getElementById","ads"],["String.fromCharCode","decodeURIComponent"],["Object.defineProperty","document.body.appendChild"],["$","adblockDetected"],["Object.assign","popunder"],["document.getElementById","ad_block"],["eval","replace"],["jQuery","AdBlock"],["setTimeout","iframeTestTimeMS"],["setTimeout","runInIframe"],["Math.floor","iframeTestTimeMS"],["Math","='\\x"],["document.createElement","onerror"],["jQuery","dismissAdBlock"],["crakPopInParams"],["onload","onclick"],["document.getElementById","banner"],["document.getElementById","blocker_div"],["document.getElementById","onscroll"],["$","#DontBloxMyAdZ"],["$","#pageWrapper"],["$","banner"],["document.getElementById","adpbtest"],["$","initDetection"],["document.getElementById","alert"],["JSON.parse","showTrkURL"],["Math","/window\\['(?:\\\\x\\d{2}){1}/"],["addEventListener","nextFunction"],["$","adblock"],["$","gandalfads"],["document.createElement","Tool"],["String.fromCharCode","atob"],["document.getElementsByTagName","script"],["String.prototype.charCodeAt","tabunder"],["$","adBlockChecker"],["$","urlForPopup"],["document.addEventListener","click"],["document.getElementById","overlay"],["setInterval","location"],["adBlockDetected"],["$",".height"],["document.documentElement","break;case $."],["RegExp","0x"],["Math.random","banner"],["spr"],["document.oncontextmenu"],["document.onmousedown"],["document.onkeydown"],["I833"],["jQuery","popunder"],["document.cookie","setOCookie"],["document.addEventListener","initBCPopunder"],["document.getElementById","adblockinfo"],["atob","encodeURIComponent"],["JSON","_0x"],["$","adblocker"],["document.createElement","document.head.appendChild"],["setTimeout","bait.css"],["RegExp","'0x"],["document.createElement","__esModule"],["Math","break"],["XMLHttpRequest","adb"],["document.getElementById","block"],["document.createElement","console"],["document.getElementById","send"],["document.addEventListener","nextFunction"],["Object.defineProperty","break;case"],["document.write","iframe"],["Date","='\\x"],["document.head.appendChild","='\\x"],["btoa","href"],["enlace"],["document.addEventListener","Popup"],["document.getElementsByTagName","appendChild"],["Math.random","Exoloader"],["jQuery","undefined"],["$","AdBlock"],["Promise","overlay"],["document.createElement","overlay"],["document.getElementById","for-variations"],["$","getElementById"],["Math.random","zonefile"],["document.createElement","pop"],["document.write","unescape"],["String.prototype.charAt"],["encodeURIComponent","XMLHttpRequest"],["disableItToContinue"],["adver"],["document.createElement","tcpusher"],["loadTool","popping"],["document.getElementById","adsrefresh"],["$","#divDownload"],["$","modal"],["jQuery","fuckAdBlock"],["jQuery","adblock"],["String.fromCharCode","break;"],["Math.round","zonefile"],["jQuery","ai_adb"],["$","setTimeout"],["document.getElementById","deleted"],["$","ads"],["jQuery","adblocker"],["$","MutationObserver"],["Math","'0x"],["$","Math.random"],["doOnce"],["setTimeout","popi"],["googlefc"],["$","detected"],["$","offsetHeight"],["document.getElementById","length"],["document.createElement","adblock"],["$","btoa"],["document.onclick","popunder"],["eval","AdBlock"],["$","prompt"],["$","friendlyduck"],["Math","decodeURIComponent"],["$","onload"],["$","click"],["_pop"],["allclick_Public"],["Math","'\\x"],["String.fromCharCode","window[_0x"],["document.querySelectorAll","adConfig"],["addEventListener","google_ad_client"],["document.querySelector","XF"],["$","hide"],["$",".test"],["$","blocker"],["jQuery","blocker"],["onload","adblock"],["document.getElementById","nextFunction"],["document.createElement","a.adm"],["addEventListener","ADBLOCK"],["jQuery","click"],["decodeURIComponent","ai_"],["Light.Popup.create"],["$","zendplace"],["addEventListener","blocker"],["addEventListener","Blocker"],["addEventListener","AdBlocker"],["document.addEventListener","adsBlocked"],["addEventListener","DOMNodeRemoved"],["document.dispatchEvent","CustomEvent"],["onload","adsbygoogle"],["window.onload","devtools"],["window.onload","innerHTML"],["addEventListener","devtools"],["addEventListener","ads"],["document.createElement","antiAdBlockerHandler"],["EventTarget.prototype.addEventListener","delete window"],["document.querySelectorAll","pastepc"],["setTimeout","localStorage"],["fetch","Math.random"],["document.createElement","adsBlocked"],["document.createElement","script[data-domain="],["setTimeout","hommy.mutation.mutation"],["ACtMan"],["atob","/popundersPerIP[\\s\\S]*?Date[\\s\\S]*?getElementsByTagName[\\s\\S]*?insertBefore/"],["$","popMagic"],["WebAssembly","Promise"],["setTimeout","l.parentNode.insertBefore(s"],["matchMedia","l.parentNode.insertBefore(s"],["document.createElement","target.appendChild(s"],["document.createElement","l.appendChild(s)"],["document.createElement","l.parentNode.insertBefore(s","/^data:/"],["pop_init"],["document.dispatchEvent","myEl"],["Math","zfgloaded"],["JSON.parse","break;case $."],["parseInt","break;case $."],["Math","break;case $."],["String.fromCharCode","/btoa|break/"],["JSON.parse","Promise"],["navigator","break;case $."],["EventTarget.prototype.addEventListener","key in document"],["Promise","JSON.parse"],["Promise","break;case $."],["JSON","break;case"],["Object","break;case $."],["decodeURI","zfgloadedpopup"],["Math","zfgcodeloaded"],["WebAssembly","atob","/^data:/"],["Date","wpadmngr.com"],["globalThis","adserverDomain","/^data:/"],["document.write",".js?_="],["fetch","break;case"],["addEventListener","HTMLAllCollection"],["b2a","ai_adb"],["b2a","ai_adb","/^data:/"],["document.createElement","googletag"],["document.createElement","admiral"],["admiral"],["document.createElement","abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/="],["$","String.fromCharCode"],["document.onclick","reklama-flash-body"],["document.addEventListener","fakeAd"],["document.createElement",".offsetHeight"],["RegExp","navigator.userAgent"],["document.addEventListener","initPop"],["document.addEventListener","Object[_0x"],["document.addEventListener","Popunder"],["jQuery","Object"],["addEventListener","AdBlock"],["document.getElementById",".style"],["document.getElementById","adsbygoogle"],["decodeURIComponent","checkAD"],["document.getElementsByTagName","adblocker"],["$","detectAdBlocker"],["Object.defineProperty","XMLHttpRequest"],["String.fromCharCode","/'shift'|break;/"],["document.createElement","shift"],["$","css"],["url","Math.random"],["$",".show"],["$","wrapfabtest"],["Math.floor","document.write"],["$","samAdBlockAction"],["RegExp","googlebot"],["eval","ignielAdBlock"],["$","advert"],["onload","adb"],["document.getElementById","show_ads"],["document.querySelector","adb"],["$",".init"],["XMLHttpRequest","ActiveXObject"],["setTimeout","Constant"],["onload","ajax"],["$","_ads"],["onload","puHref"],["Math","adthrive"],["XMLHttpRequest","null"],["adcashMacros"],["document.getElementsByClassName","offsetParent"],["bannersRequest"],["document.getElementById","body"],["ishop_codes"],["$","#advVid"],["__tnt","compatibility"],["String.fromCharCode","constructor"],["Object.defineProperty","clickHandler"],["onbeforeunload"],["String.fromCharCode","marginheight"],["mypop"],["jQuery","ads"],["document.getElementsByTagName","adn"],["onload","fetch"],["document.createElement","unblocker"],["Math","replace"],["document.getElementById","adsBlocked"],["jQuery","length"],["XMLHttpRequest","onreadystatechange"],["$","height"],["document.createElement","ignielAdBlock"],["decodeURIComponent","0x"],["jQuery","banner"],["String.fromCharCode","ai_"],["decodeURIComponent","atob"],["document.cookie",":visible"],["mMcreateCookie"],["fetch","status"],["document.getElementById","adsblock"],["document.addEventListener","adsbygoogle"],["$","test"],["fetch","result"],["document.createElement","_htas"],["document.getElementById","style.display"],["Math.floor","ExoLoader"],["quadsOptions"],["document.createElement","loadjscssfile"],["document.createElement","cookie"],["String.prototype.charCodeAt","replace"],["$","adsbygoogle"],["document.getElementById","No"],["document.addEventListener","container.innerHTML"],["Math.imul","charCodeAt"],["document.createElement","adb"],["addEventListener","ai_"],["__PoSettings"],["b2a"],["document.getElementById","JSON"],["document.getElementById","stop"],["$","fetch"],["document.getElementById","detect"],["onload","iframe"],["document.createElement","__htas"],["document.getElementsByTagName","tdBlock"],["$","modal-window"],["document.querySelector","_0x"],["Math.imul"],["document.write"],["document.getElementById","AdBlock"],["setTimeout","void 0"],["RegExp","debugger"],["loadAdBlocker"],["Math.random","bait"],["jQuery","No"],["$","RegExp"],["$","adb-btn"],["addEventListener","popunder"],["chAdblock"],["Math","String.fromCharCode"],["setTimeout",".click()"],["$","noConflict"],["setInterval","addAds"],["$","adsBlocked"],["Date","shift"],["jQuery","magnificPopup"],["document.createElement","register"],["String.fromCharCode","ai_adb"],["eval","decodeURIComponent"],["$","/\\.fadeIn|\\.show\\(.?\\)/"],["document.addEventListener","adjsData"],["$","exo"],["document.createElement","htmlAds"],["document.write","lycos_ad"],["String.fromCharCode","replace"],["navigator","popunder"],["Math","/window\\['(?:\\\\x[0-9a-f]{2}){2}/"],["Math.floor","urls.length"],["Object.defineProperty","break"],["document.getElementById","innerHTML"],["$","sam"],["document.createElement","open"],["confirm","location"],["showAdBlock"],["$","setCookie"],["$onet","adblock"],["goToURL"],["dataLayer","detectAdBlock"],["nothingCanStopMeShowThisMessage"],["document.createElement","AdBlock"],["document.getElementById","fakeElement"],["JSON.parse","htmlSectionsEncoded"],["atob","-0x1"],["$","wbar"],["document.createElement","appendChild"],["Script_Manager"],["Array.prototype.indexOf","popunder"],["alert"],["document.onkeypress"],["jQuery","modal"],["Math.floor","Math.random"],["$","push-allow-modal"],["$","localStorage"],["jQuery","ga"],["document.dispatchEvent"],["u_cfg"],["document.createElement","script.src"],["Promise","Adb"],["atob","Uint8Array"],["document.createElement","window.open"],["$","blockAdBlock"],["document.createElement","click"],["document.addEventListener","openPopup"],["ips","adb"],["addEventListener","MutationObserver"],["RegExp","$"],["document.querySelector","adblock"],["WebAssembly","_0x"],["document.getElementById","/Content/_AdBlock/AdBlockDetected.html"],["jQuery","popupAt"],["decodeURIComponent","'shift'"],["document.addEventListener","AdBlock"],["document.createElement","sliding"],["Swal.fire"],["ips.controller.register"],["addEventListener","fetch"],["document.write","cachebuster"],["$","popunder"],["document.cookie","document.head.appendChild"],["OpenInNewTab_Over"],["document.createElement","globalThis"],["addEventListener","smartpop"],["fetch","adblock"],["checkAdsBlocked"],["$","googleAdUrl"],["document.addEventListener","/google_ad_client/"],["$","popCookie"],["globalThis","shown_at"],["document.write","innerWidth"],["JSON.parse","break;case"],["getCookie","setCookie"],["$","popup"],["$","onclick"],["$","alertmsg"],["$","/adblock/i"],["eval","_0x"],["$","load_banner"],["document.readyState","initializeChecks"],["jQuery","this"],["document.getElementById","deblocker","/^data:text\\/javascript/"],["document.addEventListener","randomNumber"],["jQuery","ad-block"],["document.readyState","mdpDeblocker"],["document.createElement","break;case"],["document.readyState","callbackAdsBlocked"],["onbeforeunload","ask"],["addEventListener","location.replace"],["navigator","interceptClickEvent"],["gtag","adblock"],["document.getElementById","puURL"],["document.addEventListener","#leaderboardAd"],["document.getElementById","ablk"],["document.getElementById","/adblock/i"],["document.getElementsByClassName","wp-ad"],["setTimeout","aclib.runPop"],["Math.floor","src_pop"],["clearTimeout","popundersPerIP"],["setTimeout","document.getElementById"],["document.addEventListener","popunder"],["document.addEventListener","location.href"],["onload","localStorage"],["showTav"],["document.getElementById","window.open"],["document.addEventListener","Adblock"],["$","/undefined|displayAdBlockedVideo/"],["JSON.stringify"],["Math.random","ExoLoader"],["document.createElement","jsc.mgid.com"],["document.getElementById","adb"],["EventTarget.prototype.addEventListener","alert"],["document.createElement","warning"],["$","cdgPops"],["fetch","adb"],["document.createElement","'script'"],["document.addEventListener","localStorage"],["document.createElement","fuckAdBlock"],["document.readyState","adsBlocked"],["$","underpop"],["document.querySelector","akadb"],["aclib"],["document.createElement","zoneid"],["Date.prototype.toISOString","wpadmngr.com"],["document.write","insertAd"],["$","blockThisUrl"],["setTimeout","window.open"],["document.createElement","pop_tag"],["document.addEventListener","lastPopupTime"],["addEventListener","detect"],["document.querySelectorAll","localStorage"],["document.addEventListener","bait"],["document.createElement","/adblock/i"],["document.addEventListener","adblock"],["document.addEventListener","window.open"],["googletag"],["EventTarget.prototype.addEventListener","onerror"],["document.addEventListener","promos"],["setTimeout","getComputedStyle"],["addEventListener","fallback"],["document.createElement",".js"]];
const hostnamesMap = new Map([["walterprettytheir.com",[0,1]],["upstream.to",0],["10starhd.*",0],["animeflv.net",0],["anysex.com",0],["asianclub.*",0],["cheatermad.com",0],["downloadpirate.com",0],["drop.download",[0,87,240]],["dx-tv.com",0],["embed.casa",0],["exee.app",[0,130]],["f2movies.to",0],["fapeza.com",[0,1]],["fileone.tv",[0,45]],["films5k.com",0],["gcloud.live",0],["hdss.*",[0,262]],["hdtoday.cc",[0,277]],["hentai2read.com",[0,1,45,277]],["imx.to",0],["javstream.top",0],["just-upload.com",0],["luluvdo.com",[0,172,240,250]],["mavplay.*",0],["moviesflix.*",0],["muchohentai.com",[0,64]],["ouo.*",[0,300]],["pelisflix20.*",0],["projectfreetv.*",[0,130,259]],["qdembed.com",0],["safefileku.com",[0,38,240]],["sharelink-1.site",0],["sieutamphim.org",0],["stbemuiptv.com",0],["streamvid.net",[0,130]],["ujav.me",0],["videobb.*",0],["voirseries.*",0],["adrianmissionminute.com",0],["alejandrocenturyoil.com",[0,1]],["christopheruntilpoint.com",[0,1]],["heatherwholeinvolve.com",[0,1]],["jennifercertaindevelopment.com",[0,1]],["jilliandescribecompany.com",[0,1]],["johnalwayssame.com",[0,1]],["kellywhatcould.com",[0,1]],["kristiesoundsimply.com",[0,1]],["lukesitturn.com",[0,1]],["mariatheserepublican.com",0],["mikaylaarealike.com",[0,1]],["nathanfromsubject.com",[0,1]],["voe.sx",[0,1]],["voe.sx>>",0],["javboys.tv>>",0],["qiwi.gg",0],["javfc2.xyz",[0,1]],["18comic.vip",1],["18comic-gquu.vip",1],["adictox.com",1],["animeworld.ac",1],["anizm.net",1],["archivebate.*",1],["asiaon.*",[1,45]],["asianporn.li",1],["asiaontop.com",[1,45]],["asmr18.fans",1],["b-hentai.com",1],["bebasbokep.online",[1,522]],["bokepsin.in.net",1],["bos21.site",1],["bunkrr.*",[1,45]],["cat3movie.org",[1,45]],["cdn1.site",[1,240]],["comohoy.com",1],["cyberdrop.me",1],["daftporn.com",1],["daftsex.net",1],["datawav.club",1],["ddd-smart.net",[1,38]],["depvailon.com",[1,45]],["dvdgayonline.com",1],["ekasiwap.com",[1,15]],["fapfappy.com",1],["g-porno.com",1],["g-streaming.com",1],["goctruyentranhvui17.com",1],["hhkungfu.*",1],["hentai2w.com",[1,508]],["hentaipaw.com",1],["hitomi.la",1],["homemoviestube.com",[1,38]],["imgbox.com",1],["jav-fun.cc",1],["jav.direct",1],["jav.si",1],["javboys.com",1],["javbraze.com",[1,38]],["javfan.one",1],["javfor.tv",[1,43]],["javhat.tv",[1,38]],["javhd.*",[1,38,45]],["javhdz.today",[1,38]],["javmenu.com",1],["javmix.tv",1],["javpas.com",1],["javseen.tv",[1,38]],["javtiful.com",[1,17,38,43,231]],["jmanga.*",1],["jpg6.su",1],["klmanga.*",[1,45]],["komikmanhwa.me",1],["lovingsiren.com",1],["luluvdoo.com",[1,240,277]],["madouqu.com",1],["manga1001.*",1],["mangakakalot.gg",1],["mangaraw.*",[1,38,130]],["mangarawjp.*",1],["movieffm.net",1],["natomanga.com",1],["nekopoi.*",[1,40]],["nelomanga.*",1],["netfapx.com",1],["niyaniya.*",1],["nsfwr34.com",1],["nsfwyoutube.com",1],["nudogram.com",1],["nukibooks.com",1],["phimlongtieng.net",[1,277]],["play.playkrx18.site",1],["poapan.xyz",[1,38]],["odporn.com",1],["porn4fans.com",1],["pornslash.com",1],["porntin.com",[1,45]],["qmh.sex",1],["rawkuma.net",[1,277]],["rule34.xyz",1],["rule34vault.com",1],["savefiles.com",[1,240]],["sexdicted.com",1],["shinshi-manga.net",[1,38]],["simpcity.*",1],["spoilerplus.tv",1],["stream18.net",[1,277]],["streampoi.com",1],["sxyprn.*",[1,15,38,45]],["syosetu.*",1],["taxi69.com",1],["teenager365.to",1],["thefappening.pro",1],["thefappeningblog.com",1],["tojav.net",[1,45,319]],["turbocloud.xyz",1],["turbovid.xyz",1],["ups2up.fun",[1,240,271]],["vegamoviese.*",1],["vide0.net",[1,15,240]],["videplay.us",1],["x-fetish.tube",1],["x-x-x.video",1],["xanimeporn.com",1],["xxgasm.com",1],["xxxfree.watch",1],["youwatch.monster",1],["dsvplay.com",[1,45]],["jonathansociallike.com",1],["rubystm.com",1],["rubyvid.com",[1,240]],["rubyvidhub.com",1],["stmruby.com",1],["streamruby.com",[1,240]],["0deh.com",2],["26efp.com",[2,240]],["2glho.org",2],["58n1.com",2],["5mgz1.com",2],["6jlvu.com",2],["c1z39.com",2],["djx10.org",2],["fu-4u3omzw0.nl",2],["guum5.com",2],["hmt6u.com",2],["imdpu9eq.com",2],["kzjou.com",2],["l455o.com",2],["l8e8.com",2],["l99j.com",2],["mee-cccdoz45.com",2],["my4w.com",2],["qa2h.com",2],["qvzidojm.com",2],["tpz6t.com",2],["tz7z9z0h.com",2],["v1kkm.com",2],["xcoic.com",2],["xo7c.com",2],["z4h4.com",2],["0cbcq8mu.com",3],["2cf0xzdu.com",3],["4k2h4w04.xyz",3],["a6iqb4m8.xyz",3],["afl3ua5u.xyz",3],["jmzkzesy.xyz",3],["scjhg5oh.fun",3],["a-b-f-dd-aa-bb-cctwd3a.fun",3],["mjukb26l.fun",3],["ghajini-4urg44yg.lol",3],["a-b-c-d-e-f9jeats0w5hf22jbbxcrpnq37qq6nbxjwypsy.fun",3],["0x7jwsog5coxn1e0mk2phcaurtrmbxfpouuz.fun",3],["1nmnozg1.fun",3],["222i8x.lol",3],["279kzq8a4lqa0ddt7sfp825b0epdl922oqu6.fun",3],["2btmc2r0.fun",3],["2fb9tsgn.fun",3],["2g8rktp1fn9feqlhxexsw8o4snafapdh9dn1.fun",3],["3a38xmiv.fun",3],["56m605zk.fun",3],["5rr03ujky5me3sjzvfosr6p89hk6wd34qamf.fun",3],["723qrh1p.fun",3],["8mhlloqo.fun",3],["8rm3l0i9.fun",3],["a-b-c-d-e-f7011d0w3j3aor0dczs5ctoo2zpz1t6bm5f49.fun",3],["a-b-c-d-e-fla3m19lerkfex1z9kdr5pd4hx0338uwsvbjx.fun",3],["a-b-f-dd-aa-bb-cc61uyj.fun",3],["a-b-f-dd-aa-bb-ccn1nff.fun",3],["a-b-f-dd-aa-bb-ccyh5my.fun",3],["a-b-f2muvhnjw63ruyhoxhhrd61eszezz6jdj4jy1-b-d-t-s.fun",3],["a-b-f7mh86v4lirbwg7m4qiwwlk2e4za9uyngqy1u-b-d-t-s.fun",3],["a-b-fjkt8v1pxgzrc3lqoaz8fh7pjgygf4zh3eqhl-b-d-t-s.fun",3],["a-b-fnv7h0323ap2wfqj1ruyo8id2bcuoq4kufzon-b-d-t-s.fun",3],["a-b-fqmze5gr05g3y4azx9adr9bd2eow7xoqwbuxg-b-d-t-s.fun",3],["anqkdhcm.nl",3],["bf0skv.org",3],["bk9nmsxs.com",3],["brr-69xwmut5-moo.com",3],["ccyig2ub.nl",3],["eljgocmn.fun",3],["eximeuet.fun",3],["fdvzg.world",3],["file-1bl9ruic-moon.com",3],["file-kg88oaak-embed.com",3],["filemoon-ep11lgxt.xyz",3],["filemoon-oe4w6g0u.xyz",3],["fle-2ggdmu8q-moo.com",3],["fle-5r8dchma-moo.com",3],["fle-rvd0i9o8-moo.com",3],["fu-12qjdjqh.lol",3],["fu-1abozhcd.nl",3],["fu-1fbolpvq.nl",3],["fu-c66heipu.lol",3],["fu-e4nzgj78.nl",3],["fu-hbr4fzp4.lol",3],["fu-hjyo3jqu.lol",3],["fu-l6d0ptc6.lol",3],["fu-m03aenr9.nl",3],["fu-mqsng72r.nl",3],["fu-p6pwkgig.nl",3],["fu-pl1lqloj.nl",3],["fu-v79xn6ct.nl",3],["fu-ys0tjjs1.nl",3],["g8rnyq84.fun",3],["ghajini-04bl9y7x.lol",3],["ghajini-1fef5bqn.lol",3],["ghajini-1flc3i96.lol",3],["ghajini-8nz2lav9.lol",3],["ghajini-9b3wxqbu.lol",3],["ghajini-emtftw1o.lol",3],["ghajini-jadxelkw.lol",3],["ghajini-vf70yty6.lol",3],["ghajini-y9yq0v8t.lol",3],["go-for-it-wgt1a.fun",3],["gorro-9mqnb7j2.fun",3],["gorro-chfzoaas.fun",3],["gorro-ry0ziftc.fun",3],["h8jizwea.fun",3],["huzi6or1.fun",3],["jmtv4zqntu5oyprw4seqtn0dmjulf9nebif0.fun",3],["l1afav.net",3],["mee-6zeqsgv2.com",3],["mee-dp6h8dp2.com",3],["mee-s9o6p31p.com",3],["mkm7c3sm.com",3],["moo-teau4c9h-mkay.com",3],["moon-3uykdl2w-embed.com",3],["moon-fm43w1qv.com",3],["moon-kg83docx.com",3],["moonfile-62es3l9z.com",3],["morgan0928-5386paz2.fun",3],["morgan0928-6v7c14vs.fun",3],["morgan0928-8ufkpqp8.fun",3],["morgan0928-oqdmw7bl.fun",3],["morgan0928-t9xc5eet.fun",3],["semprefi-1h3u8pkc.fun",3],["semprefi-2tazedzl.fun",3],["semprefi-5ut0d23g.fun",3],["semprefi-7oliaqnr.fun",3],["semprefi-8xp7vfr9.fun",3],["semprefi-hdm6l8jq.fun",3],["semprefi-uat4a3jd.fun",3],["semprefi-wdh7eog3.fun",3],["stephenking-00qvxikv.fun",3],["stephenking-3u491ihg.fun",3],["stephenking-7tm3toav.fun",3],["stephenking-c8bxyhnp.fun",3],["stephenking-vy5hgkgu.fun",3],["streamio.to",3],["u26bekrb.fun",3],["u9206kzt.fun",3],["ulike-filter-sowe-canplay-rightlets-generate-themrandomlyl89u8.fun",3],["ur70sq6j.fun",3],["uthr5j7t.com",3],["vdiflcsl.fun",3],["vqjhqcfk.fun",3],["y5vx1atg.fun",3],["z1ekv717.fun",3],["z9sayu0m.nl",3],["oaaxpgp3.xyz",3],["hi0ti780.fun",3],["oimsmosy.fun",3],["unito.life",4],["motherless.com",5],["golem.de",6],["skidrowreloaded.com",7],["faz.net",8],["transfermarkt.*",[9,10]],["torlock.*",11],["torlock2.*",11],["strikeout.*",[11,17]],["viprow.*",[11,240]],["atomohd.*",[11,260]],["atomtt.com",11],["topstreams.*",[11,189]],["streamadblocker.*",[11,130]],["livesport24.net",[11,261]],["pogolinks.*",11],["1stream.*",[11,31,130]],["yts-subs.*",11],["subtitles.cam",11],["poscitech.*",[11,260]],["unblockit.*",11],["f1livegp.*",11],["sportsembed.*",11],["sportsonline.*",[11,410]],["nflstreams.me",[11,64,130]],["daddylivehd.*",[11,130]],["tutelehd.*",11],["watchtvchh.*",11],["liveon.*",11],["tennisstreams.*",[11,64,259,260,261]],["vipleague.*",[11,64,240]],["dailyuploads.net",12],["nitroflare.com",[12,34]],["oxy.*",[12,434]],["filerice.com",12],["atlasstudiousa.com",12],["gifhq.com",[12,85,257]],["hardgif.com",12],["nsfwmonster.com",12],["mylink.*",[13,259]],["my1ink.*",[13,259]],["myl1nk.*",[13,259]],["myli3k.*",[13,259]],["androidrepublic.org",14],["biqle.*",15],["cpmlink.net",15],["grantorrent.*",[15,67]],["grantorrent1.*",15],["turbobit.net",15],["inkapelis.*",[15,77]],["loveroms.*",15],["ver-pelis.*",15],["xrares.com",15],["torrentz2eu.*",[15,85]],["footballstream.tv",15],["mlbstream.tv",15],["nbastream.tv",15],["nflstream.tv",15],["bdsmporn.cc",[15,45]],["cocoporn.net",15],["dirtyporn.cc",[15,45]],["faperplace.com",[15,45]],["freeadultvideos.cc",[15,45]],["freepornstream.cc",15],["generalpornmovies.com",[15,45]],["kinkyporn.cc",[15,45]],["moviesxxx.cc",[15,45]],["movstube.net",15],["onlinefetishporn.cc",[15,45]],["peetube.cc",15],["pornonline.cc",[15,45]],["porntube18.cc",[15,45]],["streamextreme.cc",[15,45]],["streamporn.cc",[15,45]],["videoxxx.cc",[15,45]],["watchporn.cc",15],["x24.video",15],["xxxonline.cc",[15,45]],["xxxonlinefree.com",15],["xxxopenload.com",[15,45]],["dfiles.*",15],["gonzoporn.cc",[15,45]],["onlinexxx.cc",[15,45]],["tvporn.cc",[15,45]],["0xxx.ws",15],["multiup.io",15],["multiup.org",15],["multiup.eu",15],["freesoftpdfdownload.blogspot.com",15],["files.im",15],["shorterall.com",[15,260]],["all3do.com",[15,240]],["d-s.io",15],["d0o0d.com",[15,130]],["do0od.com",[15,130]],["do7go.com",[15,240]],["dood.*",[15,130]],["dooodster.com",[15,240]],["doply.net",[15,240]],["ds2video.com",[15,130]],["vidply.com",[15,240]],["vvide0.com",[15,240]],["spank-and-bang.com",15],["streamingcommunity.*",15],["pornbox.cc",[15,45]],["sturls.com",15],["alluretube.com",15],["anyxvideos.com",15],["fetishtube.cc",15],["italianporn.com.es",15],["japanporn.tv",[15,357]],["lovefap.com",15],["mommysucks.com",15],["mzansinudes.com",15],["napiszar.com",[15,45]],["of-model.com",15],["onlineporn24.com",[15,45]],["porntube15.com",15],["sexavgo.com",15],["sexdiaryz.*",[15,38]],["hispasexy.org",15],["acervodaputaria.com.br",15],["mmopeon.ru",15],["mangaraw.org",15],["uporn.icu",[15,45]],["sexgayplus.com",15],["archivebate.com",[15,45]],["wetter.com",16],["animepahe.*",[17,259]],["kwik.*",[17,258]],["seehd.*",17],["tamilyogi.*",17],["urlpay.net",17],["kropic.com",[17,45]],["ricettafitness.com",17],["yourporngod.com",17],["freeomovie.to",[17,45]],["hpaudiobooks.*",17],["xxxmax.net",17],["imagenesderopaparaperros.com",[17,261]],["xxvideoss.org",17],["zonebourse.com",18],["aofsoru.com",19],["yts.*",[20,260]],["imgdrive.net",[21,22]],["imgwallet.com",[21,22]],["imgadult.com",22],["imgtaxi.com",22],["123link.*",[23,24,25]],["pakkotoisto.com",25],["alrincon.com",26],["faps.club",26],["camsstream.com",26],["redvido.com",26],["vortez.net",27],["beermoneyforum.com",27],["ephoto360.com",27],["pornxs.com",28],["perfectgirls.*",[28,45]],["perfektdamen.*",28],["hentaipulse.com",28],["vivud.com",28],["newsextv.com",28],["anyporn.com",28],["eroprofile.com",28],["absoluporn.*",28],["mangoporn.net",29],["celebritymovieblog.com",29],["fuckundies.com",29],["pandamovies.pw",[29,31]],["khatrimaza.*",29],["watchpornx.com",29],["eskiceviri.blogspot.com",29],["hentaianimedownloads.com",29],["boobsrealm.com",29],["ah-me.com",30],["realgfporn.com",31],["fapdig.com",31],["mangovideo.*",31],["sound-park.*",[31,85]],["soundpark.*",[31,85]],["soundpark-club.*",[31,85]],["watchfreexxx.net",31],["gdtot.*",[31,130,240]],["tusfiles.com",[31,268]],["readcomicsonline.ru",31],["afrodity.sk",31],["brato.bg",31],["cotannualconference.org.uk",31],["couponsuniverse.com",31],["cycraracing.com",31],["dahh.net",31],["dlhe-videa.sk",31],["elmalajeno.com",31],["extreme-board.com",31],["free-famous-toons.com",31],["istanbulescortnetworks.com",31],["ok-th.com",31],["payt.com",31],["podkontrola.pl",31],["redtubemov.com",31],["shtab.su",31],["spiritword.net",31],["latesthdmovies.*",[31,95]],["comixzilla.com",31],["indianporn365.net",31],["brillen.de",31],["watch-series.*",32],["watchseries.*",[32,240,277]],["limetorrents.*",[32,93]],["vidcloud.*",[32,37]],["moviflex.*",32],["iir.ai",32],["01fmovies.com",[32,258]],["123moviesfun.is",32],["bmovies.*",[32,259]],["bolly4umovies.*",32],["putlocker.*",[32,130,240,258]],["deseneledublate.com",32],["movie123.*",32],["luxuretv.com",33],["planetsuzy.org",35],["onlinetv.planetfools.com",36],["gogoanime.*",[37,38]],["adsrt.*",37],["fullywatchonline.com",37],["myvidmate.*",37],["voirfilms.*",37],["converto.io",[37,258]],["tamilmv.*",37],["streamingworld.*",[37,261]],["skpb.live",37],["faucethero.com",37],["livegore.com",37],["123unblock.*",[37,322]],["2umovies.*",37],["a2zapk.*",[37,475]],["hdfull.*",38],["imgdawgknuttz.com",[38,259]],["leechall.com",38],["10convert.com",38],["2girls1cup.ca",38],["7bit.link",38],["animez.org",[38,240]],["aninavi.blog",38],["ansuko.net",38],["apnablogs.in",38],["areabokep.com",38],["asiangaysex.net",38],["asmroger.*",38],["banglachotigolpo.xyz",38],["besthdgayporn.com",[38,45]],["bigojav.com",38],["bookfrom.net",38],["dojing.net",38],["drivenime.com",38],["dtupgames.blogspot.com",38],["earnfromarticles.com",38],["echiman.com",38],["erokomiksi.com",38],["favoyeurtube.net",38],["fucksporn.com",38],["fullxcinema1.com",38],["gayfor.us",[38,45]],["gayxx.net",38],["gdrivelatinohd.net",[38,130,240]],["gigmature.com",38],["gomuraw.blog",38],["gosexy.mobi",38],["hachiraw.net",38],["hanime1-me.top",38],["hentaianimezone.com",[38,319]],["hentaiasmr.moe",[38,45]],["hentairead.io",38],["huurshe.com",38],["incgrepacks.com",38],["japangaysex.com",38],["javboys.*",[38,45]],["javsubindo.com",38],["javup.org",38],["jojolandsmanga.com",[38,45,240]],["jpopsingles.eu",[38,130,240]],["kahanighar.com",38],["kaliscan.*",38],["kfapfakes.com",38],["kiradream.blog",38],["kisscos.net",[38,43]],["kisshentaiz.com",38],["kmansin09.*",38],["kuronavi.blog",38],["leermanga.net",38],["lustesthd.makeup",38],["mangakoma01.*",38],["mangamovil.net",38],["mangaraw1001.cc",38],["mangaraw18.net",38],["mangarawjp.me",38],["manhuatop.org",38],["manhwatop.com",38],["mikohub.blog",38],["milfnut.*",[38,104]],["movibd.com",38],["naijauncut.com",38],["nicomanga.com",[38,277]],["nudeslegion.com",38],["odiafresh.com",38],["onlinework4all.com",[38,258]],["otomi-games.com",[38,45,261]],["pantieshub.net",38],["pinayflix.me",38],["piratehaven.xyz",38],["porn00.org",[38,45]],["pornohubonline.com",38],["pornxp.com",[38,45]],["raw1001.net",38],["raw18.*",38],["rawinu.com",[38,277]],["rawkuro.net",38],["redretti.com",38],["rentry.co",38],["sexpin.net",38],["shemale6.com",38],["shemaleup.net",38],["sharinghubs.com",38],["smarttrend.xyz",38],["socigames.com",38],["spotidownloader.com",38],["streamup.ws",[38,240]],["sweeteroticart.com",38],["tabooporn.tv",[38,45]],["tatli.biz",38],["teenager365.com",38],["theblank.net",38],["transflix.net",38],["turboimagehost.com",[38,45]],["vintagepornfun.com",38],["weloma.art",[38,277]],["welovemanga.one",[38,277]],["worthcrete.com",[38,95]],["xhamster.fm",[38,256]],["xmegadrive.com",38],["yabaisub.cloud",38],["yesjavplease.fun",38],["moviegan.*",38],["adslink.pw",[38,45,130,240]],["porhubvideo.com",[38,95]],["webseriessex.com",[38,95]],["panuvideo.com",[38,95,251]],["pornktubes.net",[38,95]],["feet9.com",39],["short.pe",[40,41,258]],["coinfaucet.io",[40,270]],["deepbrid.com",42],["appstore-discounts.com",42],["xianzhenyuan.cn",42],["k511.me",42],["dozarte.com",42],["getfreesmsnumber.com",42],["fstore.biz",42],["devdrive.cloud",42],["upzone.cc",[42,258]],["nifteam.info",42],["file-upload.*",42],["dewimg.*",43],["imgtown.*",43],["imgviu.*",43],["mazpic.*",43],["outletpic.*",43],["picrok.*",43],["highporn.net",[43,45]],["watchmdh.to",43],["zetporn.com",43],["1bitspace.com",[43,316]],["mgnet.xyz",[43,364]],["hideout.*",44],["hardcoreluv.com",45],["pezporn.com",45],["pussyspot.net",45],["wildpictures.net",45],["flycutlink.com",[45,87]],["4khd.com",45],["141tube.com",45],["18adultgames.com",45],["18porncomic.com",45],["19-days-manga.com",45],["1teentubeporn.com",45],["1youngteenporn.com",45],["3dhentai.club",45],["3gaytube.com",45],["3prn.com",[45,257]],["3xamatorszex.hu",45],["3xfaktor.hu",45],["4archive.org",45],["4porn4.com",45],["560pmovie.com",45],["69games.xxx",45],["6indianporn.com",45],["7mmtv.sx",45],["85po.com",45],["8muses.xxx",45],["a-hentai.tv",45],["ablefast.com",45],["adult-empire.com",45],["adultoffline.com",45],["adultporn.com.es",45],["aflamsexnek.com",45],["ahri8.*",45],["akatsuki-no-yona.com",45],["akutsu-san.com",45],["al4a.com",45],["algodaodocescan.com.br",[45,130]],["allafricangirls.net",45],["allcelebs.club",45],["allporncartoons.com",45],["allpussynow.com",45],["allureamateurs.net",45],["alotporn.com",45],["amateur-mature.net",45],["amateurfapper.com",45],["amateurfun.net",45],["amateurporn.co",45],["amazingtrannies.com",45],["amazon-love.com",45],["animecast.net",45],["animeidhentai.com",45],["animesex.me",45],["animetoast.cc",45],["annoncesescorts.com",45],["anusling.info",45],["anybunny.com",45],["aoashimanga.com",45],["arabxforum.com",45],["arabxnx.com",45],["arcjav.com",[45,64]],["asiansex.life",45],["asianpornfilms.com",45],["asianpornphoto.net",45],["asianstubefuck.com",45],["asianteenagefucking.com",45],["assesphoto.com",45],["axporn.com",45],["azmen.com",45],["babesxworld.com",45],["banglachoti-story.com",45],["bbw.com.es",45],["bbw6.com",45],["bbwfest.com",45],["bbwfuckpic.com",45],["bcmanga.com",45],["bdsm-fuck.com",45],["bdsm-photos.com",45],["bdsmstreak.com",45],["beegsexxx.com",45],["beemtube.com",45],["beginningmanga.com",45],["belloporno.com",45],["best18teens.com",45],["bestblackgay.com",45],["bestcam.tv",45],["bestgrannies.com",45],["bestlist.top",45],["bestpornflix.com",45],["bestpussypics.net",45],["bestsextoons.com",45],["bestshemaleclips.com",45],["bigboobs.com.es",45],["bigwank.com",45],["birdurls.com",[45,259]],["bjhub.me",45],["black-matures.com",45],["blackamateursnaked.com",45],["blackchubbymovies.com",45],["blackcunts.org",[45,331]],["blackmaturevideos.com",45],["blackpornhq.com",45],["blacksexmix.com",45],["blackteen.link",45],["blasensex.com",45],["blowjobamateur.net",45],["bluetv.xyz",45],["bobolike.com",45],["bokepxv.com",45],["bolly-tube.com",45],["bollywoodx.org",45],["bondagevalley.cc",45],["boobs-mania.com",45],["boolwowgirls.com",45],["booru.eu",45],["bootyexpo.net",45],["borwap.xxx",45],["boxporn.net",45],["boystube.link",45],["brazzersbabes.com",45],["bucetaspeludas.com.br",45],["bunkr.*",[45,250]],["buondua.com",45],["bustmonkey.com",45],["bustyfats.com",45],["bustyshemaleporn.com",45],["bymichiby.com",45],["cartoonporncomics.info",45],["cartoonvideos247.com",45],["cbt-tube.net",45],["cdimg.blog.2nt.com",45],["celebrityleakednudes.com",45],["celebritynakeds.com",45],["celebsnudeworld.com",45],["celebwhore.com",45],["centralboyssp.com.br",45],["cerdas.com",45],["cervezaporno.com",45],["cfake.com",45],["chatropolis.com",45],["chicasdesnudas.xxx",45],["chubbyelders.com",45],["chubbypornmpegs.com",45],["cine-calidad.*",45],["classicxmovies.com",45],["clicporn.com",45],["clothing-mania.com",45],["comicsarmy.com",45],["comicsporno.xxx",45],["comicspornos.com",45],["comicspornoxxx.com",45],["comicsvalley.com",45],["comicsxxxgratis.com",45],["comicxxx.eu",45],["crazyporn.xxx",45],["criollasx.com",45],["crossdresserhub.com",45],["csrevo.com",45],["cuckold.it",45],["cutiecomics.com",45],["czechsex.net",45],["czechvideo.org",45],["daftsex.biz",45],["darknessporn.com",45],["dataporn.pro",45],["debridup.com",45],["deepfucks.com",45],["descargaranimes.com",45],["desihoes.com",45],["desijugar.net",45],["desimms.co",45],["devere-group-hongkong.com",45],["digitalbeautybabes.com",45],["dikgames.com",45],["dirtybadger.com",45],["dirtyfox.net",45],["dirtygangbangs.com",45],["dirtytamil.com",45],["dlgal.com",45],["dlouha-videa.cz",45],["domahatv.com",45],["domahi.net",45],["donna-cerca-uomo.com",45],["dorohedoro.online",45],["doujindesu.*",[45,212]],["douxporno.com",45],["dragontranslation.net",45],["drsnysvet.cz",45],["dumpz.net",45],["ebonyassclips.com",45],["ebuxxx.net",45],["ehotpics.com",45],["eporner.video",45],["epornstore.com",45],["eroasmr.com",45],["eroclips.org",45],["erogarga.com",45],["erotichunter.com",45],["eroticmv.com",45],["eroticteensphoto.net",45],["eroxxx.us",45],["escort-in-italia.com",45],["escortconrecensione.com",45],["eshentai.tv",45],["everysextube.com",45],["ex-foary.com",45],["eztvtorrent.co",45],["familyporner.com",45],["famosas-desnudas.org",45],["famousnipple.com",45],["fap16.net",45],["fapset.com",45],["faptube.com",45],["fapxl.com",45],["fatblackmatures.com",45],["fattubevideos.net",45],["fatwhitebutt.com",45],["fatxxxtube.com",45],["femdomworld.com",45],["femjoybabes.com",45],["fetish-bb.com",45],["fetish-tv.com",45],["fetishburg.com",45],["ffjav.com",45],["film1k.com",45],["filmpertutti.*",45],["filmpornoitaliano.org",45],["filmyporno.tv",45],["finderporn.com",[45,331]],["finding-camellia.com",45],["findtranny.com",45],["finevids.xxx",45],["folgenporno.com",45],["footfetishvid.com",45],["foxnxx.com",45],["free-gay-clips.com",45],["free-trannyporn.com",45],["freefatpornmovies.com",45],["freegayporn.me",45],["freegrannypornmovies.com",45],["freehdvideos.xxx",45],["freepornhdonlinegay.com",45],["freepornjpg.com",45],["freepublicporn.com",45],["freesex-1.com",45],["freexxxvideos.pro",45],["freshscat.com",45],["freshshemaleporn.com",45],["frprn.com",45],["ftopx.com",45],["fuckingsession.com",45],["fuckmilf.net",45],["fucktube4k.com",45],["fuxnxx.com",45],["gatasdatv.com",45],["gay-streaming.com",45],["gay4porn.com",45],["gayboyshd.com",45],["gayboystube.top",45],["gayforfans.com",45],["gaypornhdfree.com",45],["gaypornhot.com",45],["gaypornlove.net",45],["gaystream.pw",45],["gayteam.club",45],["gayvideo.me",45],["gayxxxtube.net",45],["gelbooru.com",45],["ggbases.com",45],["ghettopearls.com",45],["gifcandy.net",45],["girlfriendsexphoto.com",45],["girlfuckgalleries.com",45],["girlnude.link",45],["glavmatures.com",45],["goodporn.to",45],["goshow.tv",45],["gotporn.com",45],["gotxx.*",45],["grannyxxxtube.net",45],["greatestshemales.com",45],["greatnass.com",45],["greensmut.com",45],["grigtube.com",45],["hardfacefuck.com",45],["hcbdsm.com",45],["hd-xxx.me",45],["hdgayporn.net",45],["hdjavonline.com",45],["hdpicsx.com",45],["hdporn-movies.com",45],["hdpornzap.com",45],["hdtubesex.net",45],["hentai-cosplay-xxx.com",45],["hentai-for.net",45],["hentai-hot.com",45],["hentai-senpai.*",45],["hentai.tv",45],["hentai20.io",45],["hentai3z.com",45],["hentai4k.com",45],["hentaiarena.com",45],["hentaiblue.net",45],["hentaibrasil.info",45],["hentaibros.com",45],["hentaicity.com",45],["hentaidays.com",45],["hentaienglish.com",45],["hentaihaven.com",45],["hentaihaven.red",45],["hentaihd.xyz",45],["hentaila.com",45],["hentaila.tv",45],["hentaipins.com",[45,256]],["hentaiporno.xxx",45],["hentairead.com",45],["hentaisenpai.*",45],["hentaiteca.net",45],["hentaitk.net",45],["hentaitube1.lol",45],["hentaiworld.tv",45],["hentaiyes.com",45],["herexxx.com",45],["heroine-xxx.com",45],["highheelstrample.com",45],["hindilinks4u.*",[45,258]],["hiperdex.com",45],["hit-erotic.com",45],["hitprn.com",45],["hmanga.asia",45],["holaporno.xxx",45],["hoporno.net",45],["hornbunny.com",45],["hornyfanz.com",45],["hotgirl.biz",45],["hotgirlhub.com",45],["hotleak.vip",45],["hotleaks.tv",45],["hotmarathistories.com",45],["hotmaturegirlfriends.com",45],["hotntubes.com",45],["hotsexstory.xyz",45],["hotshag.com",45],["house.porn",45],["hqporner.com",45],["hqpornero.com",45],["hqpornstream.com",45],["huyamba.*",45],["ibbs.pro",45],["ibecamethewifeofthemalelead.com",45],["ibradome.com",45],["iceporn.tv",45],["ideal-teens.com",45],["ilikecomix.com",45],["imagetwist.netlify.app",45],["imgflare.com",45],["in91vip.win",45],["incontri-in-italia.com",45],["indiansexbazar.com",45],["indianxxx.us",45],["influencersgonewild.com",45],["ingyenszexvideok.hu",45],["iusedtobeaboss.com",45],["j-pussy.com",45],["j91.asia",45],["japaneseasmr.com",45],["japanfuck.com.es",45],["japantaboo.com",45],["japanxxxmovie.com",45],["japteenx.com",45],["jasmr.net",45],["jav-torrent.org",45],["jav-xx.com",45],["jav.one",45],["jav101.online",45],["jav380.com",45],["javbake.com",45],["javball.com",45],["javbee.vip",45],["javbest.xyz",45],["javbix.com",45],["javbob.co",45],["javbull.tv",45],["javcensored.net",45],["javcl.com",45],["javdoge.com",45],["javenspanish.com",45],["javfav.com",45],["javfullmovie.com",45],["javfun.me",45],["javgay.com",45],["javgrab.com",45],["javheroine.com",45],["javhoho.com",45],["javhun.com",45],["javjavhd.com",45],["javmelon.com",45],["javmilf.xyz",45],["javmobile.net",45],["javmoviexxx.com",45],["javneon.tv",45],["javnew.net",[45,213]],["javopen.co",45],["javpan.net",45],["javpool.com",45],["javporn18.com",[45,333]],["javpornfull.com",45],["javprime.net",45],["javpro.cc",45],["javrave.club",45],["javraveclub.com",45],["javrip.net",45],["javroi.com",45],["javsaga.ninja",45],["javsex.guru",45],["javsexfree.com",45],["javstor.com",45],["javstream.com",45],["javtsunami.com",45],["javuncensored.watch",45],["javxxxporn.com",45],["jizz.us",45],["jotea.cl",45],["jpg.fishing",45],["jpg2.su",45],["jpvhub.com",45],["juicy3dsex.com",45],["jujmanga.com",45],["jujustu-kaisen.com",45],["justsexpictures.com",45],["justtoysnoboys.com",45],["kaoskrew.org",45],["kenzato.uk",45],["kiaporn.com",45],["kill-the-hero.com",45],["kissjav.*",[45,250]],["klikmanga.com",45],["komikstation.com",45],["komisanwamanga.com",45],["krx18.com",45],["kubo-san.com",45],["kvador.com",45],["latino69.fun",45],["latinohentai.com",[45,375]],["ldkmanga.com",45],["leakedzone.com",45],["leaktube.net",45],["lesbiansex.best",45],["lesbiantube.club",45],["lesboluvin.com",45],["lewdstars.com",45],["lewdweb.net",45],["likuoo.video",45],["ljcam.net",45],["lnk2.cc",45],["longporn.xyz",45],["lovelynudez.com",45],["lulu.st",[45,172,240,250]],["luscious.net",45],["lustteens.net",45],["mainporno.com",45],["mamochki.info",45],["manga-dbs.com",45],["manga-scantrad.*",45],["manga18.club",45],["manga18fx.com",45],["mangadass.com",45],["mangadna.com",[45,259]],["mangaforfree.com",45],["mangahub.io",[45,259]],["mangakio.com",45],["mangaonline.fun",45],["mangarawjp.asia",45],["mangarussia.com",45],["mangas-origines.fr",45],["manhwa18.cc",45],["manhwahentai.me",45],["manhwaread.com",45],["manhwas.*",45],["manhwaus.net",45],["manyakan.com",45],["mature-tube.sexy",45],["mature4.net",45],["maturepornjungle.com",45],["maturepornphoto.com",45],["maturexxxclips.com",45],["maxjizztube.com",45],["maxtubeporn.net",45],["mdtaiwan.com",45],["meetdownload.com",45],["meetimgz.com",45],["megadede.*",45],["megapornfreehd.com",45],["mespornogratis.com",45],["micmicidol.*",45],["migliori-escort.com",45],["milftoon.xxx",45],["milkporntube.com",45],["mlookalporno.com",45],["mobifuq.com",45],["mobileporn.cam",45],["mom-pussy.com",45],["mommy-pussy.com",45],["mommyporntube.com",45],["momspost.com",45],["momtubeporn.xxx",45],["momxxx.video",45],["momzr.com",45],["moregirls.org",45],["movies18.net",45],["mp4-porn.net",45],["mrjav.net",45],["mrpeepers.net",45],["muchfap.com",45],["multporn.net",45],["musvozimbabwenews.com",45],["mydesibaba.com",45],["mydesiboobs.com",45],["mygalls.com",45],["mypornhere.com",[45,359]],["mypornstarbook.net",45],["mypussydischarge.com",45],["mywatchseries.*",[45,240]],["myxclip.com",45],["myyoungbabe.com",45],["myyouporn.com",45],["nangiphotos.com",45],["naughtyza.co.za",45],["needgayporn.com",45],["netfuck.net",45],["nhentai.*",45],["nicheporno.com",45],["nightlifeporn.com",45],["nocfsb.com",45],["noindexscan.com",45],["novojoy.com",45],["novoporn.com",45],["nsfw247.to",45],["nsfwalbum.com",45],["nsfwgify.com",45],["nude-beach-tube.com",45],["nude-teen-18.com",45],["nudebeachpussy.com",45],["nudeblackgirlfriend.com",45],["nudedxxx.com",45],["nudemomshots.com",45],["nudevista.*",45],["nudismteens.com",45],["nudistic.com",45],["nyaatorrent.com",45],["ok.xxx",45],["onepiece-manga-online.net",45],["onepiecemangafree.com",45],["onepunch-manga.com",45],["onepunch.*",45],["onlineporno.cc",45],["onlinepornushka.com",45],["onlinesextube.com",45],["onlygangbang.com",45],["onlygayvideo.com",45],["onscreens.me",45],["oosex.net",45],["opomanga.com",45],["orgasmatrix.com",45],["otakuporn.com",45],["otakuraw.net",45],["overhentai.net",45],["palimas.*",45],["pasend.*",45],["perfektdamen.co",45],["pervertium.com",45],["petitegirlsnude.com",45],["phim85.com",45],["phonerotica.com",45],["pianmanga.*",45],["picsfuck.org",45],["picspornamateur.com",45],["pictoa.com",45],["pinayviralsexx.com",45],["pinkporno.*",45],["pinsexygirls.com",45],["pisshamster.com",45],["pissingporn.com",45],["pixhost.*",45],["plumpxxxtube.com",45],["porcore.com",45],["porn-sexypics.com",45],["porn0.tv",45],["porn0video.com",45],["porn3dx.com",45],["porn720.*",45],["porn77.info",45],["porn78.info",45],["pornabcd.com",45],["pornachi.com",45],["pornbimbo.com",45],["pornchaos.org",45],["pornchimp.com",45],["porncomics.*",45],["porndaa.com",45],["pornditt.com",45],["porndollz.com",45],["porner.tv",45],["pornfuzzy.com",45],["porngayclips.com",45],["porngirlstube.com",45],["porngq.com",45],["porngun.net",45],["pornhat.*",45],["pornhd8k.*",45],["pornhdin.com",45],["pornhegemon.com",45],["pornhex.com",45],["pornhub-teen.com",45],["porninblack.com",45],["pornissimo.org",45],["pornken.com",45],["pornktube.*",45],["pornlore.com",45],["pornloupe.com",45],["pornmam.com",45],["pornmom.net",45],["pornmoms.org",45],["pornmonde.com",45],["porno-porno.net",45],["porno-rolik.com",45],["pornocolegialas.org",45],["pornocolombiano.net",45],["pornohd.blue",45],["pornoman.pl",45],["pornomanoir.com",45],["pornone.com",[45,117]],["pornoperra.com",45],["pornopics.site",45],["pornoreino.com",45],["pornotrack.net",45],["pornovka.cz",45],["pornpaw.com",45],["pornrabbit.com",45],["pornrewind.com",45],["pornrusskoe.com",45],["pornsai.com",45],["pornsex-pics.com",45],["pornstargold.com",45],["pornstarsadvice.com",45],["porntape.net",45],["porntn.com",[45,344]],["porntrex.video",45],["porntry.com",45],["pornuj.cz",45],["pornvibe.org",45],["pornwatchers.com",45],["pornxp.org",45],["pornxxxvideos.net",45],["pornyeah.com",45],["pornzone.com",45],["povaddict.com",45],["prothots.com",45],["pulpo69.com",45],["punishworld.com",45],["pussy3dporn.com",45],["pussymaturephoto.com",45],["pvip.gratis",45],["pygodblog.com",45],["qcock.com",45],["queerdiary.com",45],["raccontivietati.com",45],["ragnarokmanga.com",45],["randomarchive.com",45],["rapidzona.tv",45],["rawofficethumbs.com",45],["readfireforce.com",45],["realitybrazzers.com",45],["recordbate.com",45],["redamateurtube.com",45],["reddflix.com",45],["redgay.net",45],["rednowtube.com",45],["redpornnow.com",45],["reifporn.de",45],["repicsx.com",45],["risefromrubble.com",45],["rokuhentai.com",45],["roshy.tv",[45,248]],["rphangx.net",45],["rubias19.com",45],["rule34.art",45],["rule34.paheal.net",45],["rule34porn.net",45],["rushporn.xxx",45],["russkoevideoonline.com",45],["rusteensex.com",45],["saint.to",45],["sankakucomplex.com",45],["saradahentai.com",45],["scat.gold",[45,101]],["scatkings.com",45],["scatnetwork.com",45],["secondcomingofgluttony.com",45],["see-xxx.com",45],["seed69.com",45],["sekaikomik.live",45],["seksrura.net",45],["seksualios.com",45],["seneporno.com",45],["seoul-station-druid.com",45],["seriesyonkis.*",45],["sesso-escort.com",45],["severeporn.com",45],["sex-babki.com",45],["sex-pic.info",45],["sex-torrent.net",45],["sexbixbox.com",45],["sexgay18.com",45],["sexkbj.com",45],["sexmutant.com",45],["sexmv.com",45],["sexoverdose.com",45],["sexpornasian.com",45],["sexpox.com",45],["sexpuss.org",45],["sexrura.com",45],["sexrura.pl",45],["sextor.org",45],["sextubefun.com",45],["sextubeset.com",45],["sexvideos.host",45],["sexy-games.*",45],["sexy-parade.com",45],["sexy-youtubers.com",45],["sexyaporno.com",45],["sexyasianteenspics.com",45],["sexybabespictures.com",45],["sexyebonyteen.com",45],["sexyerotica.net",45],["sexyfreepussy.com",45],["sexygirl.cc",45],["sexyhive.com",45],["sexyteengirlfriends.net",45],["shelovesporn.com",45],["shemalegape.net",45],["shemalemovies.us",45],["shemaletoonsex.com",45],["shlink.net",45],["short.croclix.me",45],["simply-hentai.com",45],["sissytube.net",45],["sitarchive.com",45],["skinnyhq.com",45],["sleazedepot.com",45],["smotret-porno-onlain.com",45],["solomax-levelnewbie.*",45],["solomaxlevelnewbie.*",45],["solopornoitaliani.xxx",45],["somulhergostosa.com",45],["socialmediagirls.com",45],["sousou-no-frieren.*",45],["speedporn.net",45],["spy-x-family.*",45],["spycock.com",45],["stileproject.com",45],["str8ongay.com",45],["stream-69.com",45],["streamhub.*",[45,130]],["subdivx.com",45],["submissive-wife.net",45],["supremebabes.com",45],["sweetgirl.org",45],["szexvideok.hu",45],["tabootube.*",45],["tamilsexstory.net",45],["teenamateurphoto.com",45],["teenbabe.link",45],["teencamx.com",45],["teenpornjpg.com",45],["teenxxxporn.pro",45],["telugusexkathalu.com",45],["tenseishitaraslimedattaken-manga.com",45],["thaihotmodels.com",45],["thatav.net",45],["thebarchive.com",45],["thebeginningaftertheend.*",45],["thecartoonporntube.com",45],["theeminenceinshadowmanga.com",45],["thefantazy.com",45],["thehentaiworld.com",45],["thelesbianporn.com",45],["thematurexxx.com",45],["theyarehuge.com",[45,330]],["thothd.com",45],["thotporn.tv",45],["thotsbay.tv",45],["thotslife.com",45],["tioanime.com",45],["titsintops.com",[45,432]],["tmohentai.com",45],["tok-thots.com",45],["tokyo-ghoul.online",45],["tokyomotion.com",45],["tokyomotion.net",45],["tomatespodres.com",45],["tomb-raider-king.com",45],["toonanime.*",45],["topjav.tv",45],["topwebgirls.eu",45],["torrent-pirat.com",45],["torture1.net",45],["tpornstars.com",45],["trahino.net",45],["trahodom.com",45],["tranny6.com",45],["trannylibrary.com",45],["trannyline.com",45],["trannysexmpegs.com",45],["trannyxxxtube.net",45],["transexuales.gratis",45],["truyenhentai18.net",45],["ts-mpegs.com",45],["tsmovies.com",45],["tubegaytube.com",45],["tubepornnow.com",45],["tuberzporn.com",45],["tubexo.tv",45],["tuhentaionline.com",45],["turbogvideos.com",45],["twink-hub.com",45],["ulsex.net",45],["ultraten.net",45],["uncensoredleak.com",45],["uniqueten.net",45],["up-load.io",[45,260]],["upicsz.com",45],["upskirt.tv",45],["urgayporn.com",45],["usaxtube.com",45],["vcp.xxx",45],["ver-mangas-porno.com",45],["verhentai.top",45],["vermangasporno.com",45],["verpeliculasporno.gratis",45],["videodotados.com",45],["videos-xxx.*",45],["videosputas.xxx",45],["videosxxxporno.gratis",45],["videosxxxputas.com",45],["viewmature.com",45],["vintageporntubes.com",45],["vipporns.com",45],["viralxvideos.es",45],["vkrovatku.com",45],["voyeurblog.net",45],["voyeurxxxsex.com",45],["vzrosliedamy.com",45],["wannafreeporn.com",45],["wantmature.com",45],["waploaded.com",[45,260]],["watchfreejavonline.co",45],["watchfreekav.com",45],["watchhentai.net",45],["watchporn.*",45],["watchporninpublic.com",45],["watchseries1.*",[45,130]],["webcams.casa",45],["webtoonscan.com",45],["westmanga.info",45],["wetpussy.sexy",45],["wetsins.com",45],["womennaked.net",45],["wonporn.com",45],["worldsex.com",45],["wow-mature.com",45],["wowxxxtube.com",45],["x-videos.name",45],["xanimehub.com",45],["xanimu.com",45],["xculitos.com",45],["xemales.com",45],["xexle.com",45],["xfantazy.com",45],["xfantazy.org",45],["xforum.live",45],["xfreehd.com",45],["xfreepornsite.com",45],["xhamsterteen.com",45],["xkeezmovies.com",45],["xn--algododoce-j5a.com",45],["xnxx-downloader.net",45],["xnxx.party",45],["xnxxhamster.net",45],["xpicse.com",45],["xpornzo.com",45],["xsexpics.com",45],["xspiel.com",45],["xsportshd.com",45],["xszav.club",45],["xvideis.cc",45],["xvideos.name",45],["xx.knit.bid",45],["xxf.mobi",45],["xxr.mobi",45],["xxu.mobi",45],["xxx-videos.org",45],["xxxcomics.org",45],["xxxfiles.*",45],["xxxhub.cc",45],["xxxlesvianas.com",45],["xxxputas.net",45],["xxxtor.com",45],["xxxxselfie.com",45],["xxxxxx.hu",45],["y-porn.com",45],["yaoiscan.com",45],["yona-yethu.co.za",45],["yongfucknaked.com",45],["youlikeboys.com",45],["youngbelle.net",45],["youngerasiangirl.net",45],["youngerporn.mobi",45],["youngleak.com",[45,257]],["youpornfm.com",45],["youramateurporn.com",45],["yporn.tv",45],["ytanime.tv",[45,261]],["yy1024.net",45],["zonavideosx.com",45],["zthots.com",45],["amateurs-fuck.com",45],["sex-amateur-clips.com",45],["dads-banging-teens.com",45],["mature-chicks.com",45],["embedmoon.*",[45,408]],["filemoon.*",[45,407,408]],["kerapoxy.*",[45,130,408]],["xnxxcom.xyz",[45,487,488,489]],["freeshot.live",45],["actionviewphotography.com",45],["exporntoons.net",45],["tyler-brown.com",45],["ukdevilz.com",45],["stream2watch.*",[46,261]],["haxmaps.com",47],["animeflv.*",[48,240]],["hyperdebrid.*",49],["divxtotal.*",50],["divxtotal1.*",50],["birdsandblooms.com",51],["bombshellbling.com",51],["dorkly.com",51],["dryscalpgone.com",51],["eclypsia.com",51],["familyhandyman.com",51],["gala.fr",51],["gentlemansgazette.com",51],["homeschoolgiveaways.com",51],["hotbeautyhealth.com",51],["ketoconnect.net",51],["mom4real.com",51],["mynaturalfamily.com",51],["oneessentialcommunity.com",51],["pageflutter.com",51],["printablecrush.com",51],["psychologyjunkie.com",51],["skinnyms.com",51],["skintagsgone.com",51],["stayglam.com",51],["tasteandtellblog.com",51],["thecelticblog.com",51],["thecozyapron.com",51],["theendlessmeal.com",51],["thehappierhomemaker.com",51],["thelovenerds.com",51],["yellowblissroad.com",51],["pelisplus2.*",52],["minecraftraffle.com",53],["desiupload.*",54],["kino-zeit.de",54],["uploadraja.com",54],["vintage-erotica-forum.com",[55,56]],["siamfishing.com",57],["haaretz.co.il",58],["haaretz.com",58],["farmeramania.de",59],["douploads.*",59],["dreamdth.com",[59,95]],["dloady.com",59],["jacquieetmichelelite.com",59],["hostingunlock.com",59],["vipracing.*",59],["hwreload.it",59],["mangafreak.me",60],["crazyshit.com",61],["anonymousemail.me",62],["auto-data.net",62],["seeitworks.com",62],["gogodl.com",62],["bg-gledai.*",62],["traductionjeux.com",62],["itopmusics.com",[62,130,248]],["ttsfree.com",62],["vipbox.*",63],["l23movies.*",63],["123moviess.*",63],["123movieshub.*",[63,130]],["modagamers.com",63],["cracksports.me",63],["forgepattern.net",63],["sportsonline.si",63],["estrenosflux.*",63],["antenasports.ru",[63,130]],["embedstream.me",[63,130,268]],["roystream.com",[63,130]],["cricstream.me",64],["cety.app",64],["exe-urls.com",64],["exego.app",64],["cutlink.net",64],["cutyurls.com",64],["cutty.app",64],["cutnet.net",64],["jixo.online",64],["efhjd.com",64],["boxingstream.me",[64,240]],["buffsports.io",64],["buffstreams.*",[64,130]],["embedsports.top",64],["game3rb.com",[64,261]],["glodls.to",[64,276]],["igg-games.com",[64,78]],["manhwalist.com",64],["mc-hacks.net",64],["miraculous.*",64],["mycivillinks.com",64],["s2dfree.to",64],["soap2day.*",[64,240,259]],["tv247.us",64],["vidsrc.*",[64,130,240,259]],["vipboxtv.*",64],["woiden.com",64],["wonderapk.com",64],["tennisonline.me",[64,130]],["wkyc.com",65],["video1tube.com",65],["hotcopper.com.au",66],["ddlvalley.*",68],["youmath.it",69],["nulledteam.com",70],["nzbstars.com",71],["vixenless.com",72],["camslib.com",73],["camwhores.*",73],["camwhorestv.*",73],["anon-v.com",[73,80]],["cambabe.*",[73,103]],["camgirlbay.net",73],["ievaphone.com",73],["camclips.tv",73],["dirtyship.com",73],["thotvids.com",73],["rodude.com",73],["uploadbaz.*",[73,379]],["bestialitytaboo.tv",74],["bestialitysextaboo.com",74],["mujeresdesnudas.club",74],["videos1002.com",74],["hdbraze.com",75],["boards.net",76],["freeforums.net",76],["proboards.com",76],["camwhoresbay.com",79],["javbangers.com",[79,140,319]],["redtube.*",81],["pornhub.*",81],["dailyfreebits.com",82],["naughtymachinima.com",83],["peliculas24.*",84],["zpaste.net",[85,261]],["udvl.com",85],["gochyu.com",85],["amindi.org",85],["undeniable.info",86],["klartext-ne.de",87],["ads-ti9ni4.blogspot.com",87],["bouamra.blogspot.com",87],["cintateknologi.com",87],["este-walks.net",87],["funnymadworld.blogspot.com",87],["gfilex.blogspot.com",87],["intest.tv",87],["irasutoya.blogspot.com",87],["laurasia.info",87],["mmo69.com",87],["pramejarab.blogspot.com",87],["thelibrarydigital.blogspot.com",87],["tienganhedu.com",87],["tienichdienthoai.net",87],["umagame.info",87],["xbox360torrent.com",87],["xn--k9ja7fb0161b5jtgfm.jp",87],["ysokuhou.blog.jp",87],["officecoach24.de",87],["samaysawara.in",87],["daemonanime.net",[87,95,255]],["webcreator-journal.com",87],["withukor.com",87],["mizugigurabia.com",87],["hayamimi-gunpla.com",87],["forogore.com",87],["codare.fun",87],["aimasummd.blog.fc2.com",87],["dokuo666.blog98.fc2.com",87],["metamani.blog15.fc2.com",87],["newssokuhou666.blog.fc2.com",87],["touhoudougamatome.blog.fc2.com",87],["youkaiwatch2345.blog.fc2.com",87],["mediapemersatubangsa.com",87],["love-stoorey210.net",87],["megawypas.com",87],["oneotv.com",87],["5ggyan.com",87],["burnbutt.com",87],["valuable.hatenablog.com",87],["gaget.hatenablog.com",87],["lib.hatenablog.com",87],["descargasok.*",87],["gametter.com",87],["toramemoblog.com",87],["akw.cam",87],["blog.livedoor.jp",87],["blogx.almontsf.com",87],["moviejones.de",88],["tennisactu.net",89],["btcbitco.in",[89,236,237]],["btcsatoshi.net",89],["wiour.com",89],["bitssurf.com",89],["pirateproxy.*",[90,91]],["thehiddenbay.com",90],["mangalek.com",90],["plc247.com",90],["thurrott.com",92],["file4go.*",[94,240]],["scrapywar.com",95],["freecoursesite.com",95],["dutchycorp.*",95],["aquariumgays.com",95],["uptechnologys.com",95],["sevenjournals.com",95],["aiimgvlog.fun",[95,214]],["moderngyan.com",95],["sattakingcharts.in",95],["bgmi32bitapk.in",95],["bankshiksha.in",95],["earn.mpscstudyhub.com",95],["earn.quotesopia.com",95],["money.quotesopia.com",95],["best-mobilegames.com",95],["learn.moderngyan.com",95],["bharatsarkarijobalert.com",95],["quotesopia.com",95],["creditsgoal.com",95],["blog4nx.com",95],["1xanime.in",95],["anhdep24.com",95],["asideway.com",95],["tecnotutoshd.net",95],["world4ufree.*",[95,260]],["freemagazines.top",95],["movi.pk",95],["vectogravic.com",95],["downloadcursos.top",95],["freejav.guru",95],["193.124.191.200",95],["cardiagn.com",95],["routech.ro",95],["gigacourse.com",95],["switch520.com",95],["techymedies.com",95],["samuraiscan.com",95],["electomania.es",95],["vfxdownload.net",95],["rtilinks.com",95],["moddedguru.com",95],["mlsbd.*",[95,261]],["itdmusics.com",95],["bullfrag.com",95],["actresstoday.com",95],["sportsdark.com",95],["freecoursesites.com",95],["gcertificationcourse.com",95],["infinityblogger.in",95],["chiangraitimes.com",95],["aresmanga.com",95],["dubznetwork.com",[95,388]],["needrombd.com",[95,259]],["bithub.win",95],["freeshib.biz",[95,101]],["whats-on-netflix.com",95],["dongknows.com",95],["akumanimes.com",95],["nullpk.com",[95,260]],["apkmagic.com.ar",95],["hentaiseason.com",95],["allpremium.net",95],["smgplaza.com",95],["topsporter.net",[95,134,430]],["allotech-dz.com",95],["simulatormods.com",95],["7xm.xyz",95],["hayatarehber.com",95],["173.249.8.3",95],["dktechnicalmate.com",95],["bitcosite.com",95],["haber.eskisehirde.net",95],["gamedrive.org",95],["ravenscans.com",95],["fap-nation.org",95],["45.86.86.235",95],["cryptofaucet.xyz",95],["mastaklomods.com",95],["tecnoyfoto.com",95],["freemagazinespdf.com",95],["rpupdate.cc",95],["butterpolish.com",95],["buxfaucet.com",95],["faucetcaptcha.co.in",95],["gameblog.in",95],["needbux.com",95],["im9.eu",95],["trigonevo.com",95],["freemodsapp.in",95],["onlytech.com",[95,353]],["dramafren.org",[95,240]],["andiim3.com",96],["kompas.com",97],["namemc.com",98],["pockettactics.com",99],["tribunnews.com",100],["camgirlfap.com",101],["fr.streamon-sport.ru",[101,130]],["hoca4u.com",101],["bitzite.com",101],["mdbekjwqa.pw",101],["vinylcollective.com",102],["cambay.tv",[103,104]],["caminspector.net",[103,104]],["camporn.tube",[103,104]],["camwhorescloud.com",[103,104]],["camwhorespy.com",[103,104]],["camwhoria.com",103],["camvideos.org",[103,104]],["camwhoreshd.com",104],["camflow.tv",104],["camhoes.tv",104],["gaytail.com",104],["guitarnick.com",105],["homebooster.de",106],["newhome.de",106],["porconocer.com",107],["scamalot.com",108],["beautypackaging.com",109],["coatingsworld.com",109],["contractpharma.com",109],["happi.com",109],["inkworldmagazine.com",109],["labelandnarrowweb.com",109],["mpo-mag.com",109],["nutraceuticalsworld.com",109],["odtmag.com",109],["printedelectronicsnow.com",109],["savevideo.me",110],["situsberita2terbaru.blogspot.com",111],["syracusefan.com",112],["argio-logic.net",113],["typinggames.zone",113],["uplink.my.id",113],["x08.ovh",[114,115]],["3ixcf45.cfd",[114,408]],["76078rb.sbs",[114,408]],["embedme.*",[114,130,408]],["filemooon.top",[114,408]],["finfang.*",[114,130,408]],["fmembed.cc",[114,130,408]],["fmoonembed.pro",[114,130,408]],["hellnaw.*",[114,130,408]],["moonembed.*",[114,130,408]],["rgeyyddl.skin",[114,200,408]],["z12z0vla.*",[114,130,408]],["4download.net",116],["globalssh.net",116],["debgen.fr",116],["jumpmanclubbrasil.com.br",116],["cheatglobal.com",116],["hd-tch.com",116],["anonymousceviri.com",116],["larvelfaucet.com",116],["abukabir.fawrye.com",116],["sshconect.com.br",116],["blograffo.net",116],["arab4media.com",116],["uvnc.com",116],["pythonmatplotlibtips.blogspot.com",116],["addonbiz.com",116],["gagaltotal666.my.id",116],["sms-receive.net",117],["reverso.net",117],["vz.lt",117],["3dprintersforum.co.uk",118],["gamecopyworld.*",119],["xpaja.net",120],["dailysport.*",120],["rojadirecta-tv-en-vivo.blogspot.com",120],["chochox.com",120],["mrdeepfakes.com",121],["imagetwist.com",121],["milfzr.com",122],["wemakesites.net",123],["alimaniacky.cz",124],["za.gl",[125,126,127]],["moretvtime.*",128],["tvguia.es",129],["6hiidude.gold",130],["0123movie.*",130],["10starhub.com",130],["11xmovies.*",[130,240]],["123chill.*",130],["123mkv.*",130],["123movies-free.*",130],["123movies-org.*",130],["123movies.*",130],["123moviesfree.*",[130,260]],["123movieweb.*",130],["190.115.18.20",130],["1cloudfile.com",130],["1direct-cloud.*",130],["1hd.to",130],["1movieshd.*",130],["1qwebplay.xyz",130],["1todaypk.*",130],["1vid1shar.space",130],["2kmovie.*",130],["3kmovies.*",130],["4movierulz.*",130],["4movierulz1.*",130],["5movies.*",130],["5moviess.com",130],["720pflix.*",[130,240]],["7moviesrulz.*",130],["7starhd.*",[130,240,300]],["7starmv.com",130],["9anime.pe",130],["9goals.live",130],["9kmovies.*",[130,260]],["9xflix.*",130],["a8ix.*",130],["adblocktape.*",130],["aflizmovies.com",130],["ak4eg.*",[130,437]],["aliezstream.pro",130],["amsmotoresllc.com",130],["anihdplay.com",130],["animeonline.ninja",130],["animesultra.net",130],["animixplay.*",130],["aniwatch.*",130],["antennasports.ru",130],["arbsd.*",130],["asianhdplay.*",130],["atishmkv.*",130],["b4ucast.com",130],["backfirstwo.site",130],["bdmusic28.*",130],["blogesque.net",130],["bolly2tolly.*",130],["bollyflix.*",130],["bowfile.com",[130,268]],["capo5play.com",130],["cinemabaz.com",130],["claplivehdplay.ru",130],["clickndownload.*",[130,240]],["comedyshow.to",130],["cool-etv.net",130],["couchtuner.*",[130,131]],["crackstreamshd.click",130],["crvsport.ru",130],["d0000d.com",130],["d000d.com",130],["daddylive1.*",130],["darkibox.com",130],["defienietlynotme.com",130],["direct-cloud.*",130],["divicast.com",130],["divxfilmeonline.net",130],["dlhd.*",130],["doods.pro",130],["dooood.*",130],["downloadhub.*",130],["ds2play.com",130],["dwlinks.buzz",130],["egybest.*",130],["embedpk.net",130],["embedplayer.*",130],["embtaku.*",130],["emovies.*",130],["encurtandourl.com",130],["engvideo.net",130],["esportivos.*",130],["explorosity.net",130],["extremosports.club",130],["f123movies.com",130],["faselhd-watch.*",130],["faselhd.*",130],["faselhdwatch.*",130],["filemooon.*",130],["film4e.com",130],["filmeserialeonline.org",130],["filmy-hit.*",130],["filmygod.*",130],["filmyhitt.com.in",130],["fiveyardlab.com",130],["flashsports.org",130],["flixhq.*",130],["flostreams.xyz",[130,240]],["flybid.net",130],["fmoonembed.*",130],["fmoviesfree.*",130],["focus4ca.com",130],["footballandress.club",130],["footybite.to",130],["footyhunter.lol",130],["forex-trnd.com",130],["freemovies.*",130],["freemoviesfull.com",130],["french-streams.cc",130],["fsl-stream.lu",130],["fullfreeimage.com",130],["futemax.zip",130],["game-2u.com",130],["gamovideo.com",130],["gdrivelatino.net",130],["globalstreams.xyz",130],["gocast.pro",130],["gocast2.com",130],["godzcast.com",130],["gogohd.*",130],["gokutv.*",130],["gomovies.*",[130,277]],["hamburgerinsult.com",130],["harimanga.com",130],["hdfriday.*",130],["hdhub4u.*",[130,240]],["hdmoviehub.*",130],["hdmovies23.*",130],["hdtoday.tv",130],["hexload.com",[130,240]],["hihihaha1.xyz",130],["hitsports.pro",130],["hollymoviehd.*",130],["hurawatchz.to",[130,277]],["iflixmovies.*",130],["imagelovers.com",130],["instalker.org",130],["isaidub6.net",130],["itopmusic.com",130],["japscan.lol",130],["jockantv.com",[130,260]],["kaido.to",130],["kickassanime.*",130],["kinoger.*",130],["klubsports.*",130],["koora.vip",130],["kunmanga.com",130],["kuttymovies1.com",130],["lewblivehdplay.ru",[130,240]],["ligaset.com",130],["likemanga.io",130],["ling-online.*",130],["linkedmoviehub.top",130],["livestreames.us",130],["locatedinfain.com",130],["lrepacks.net",[130,240]],["mangareader.to",130],["mcrypto.club",130],["medeberiyas.com",130],["mega4upload.com",130],["megadb.net",130],["megafilmeshd50.com",130],["megaupto.com",130],["mhdsports.*",130],["mhdsportstv.*",130],["mhdtvsports.*",130],["mkvcinemas.*",[130,277]],["mkvmoviespoint.autos",130],["mlwbd.*",130],["mmastreams.me",130],["moviebaaz.*",130],["moviekids.tv",130],["movielinkhub.xyz",130],["movieplay.*",130],["movies2k.*",[130,260]],["movies4u.*",[130,240]],["movies4u3.*",130],["moviesda4.*",130],["movieshd.watch",130],["moviesjoy.*",[130,240]],["moviesrulz.*",130],["moviestowatch.tv",130],["moviesverse.*",[130,260]],["movieuniverse.*",130],["moviezwap.*",[130,240]],["mp3fusion.net",[130,260]],["mp4upload.com",130],["mreader.co",130],["multicanais.*",130],["mydownloadtube.*",130],["myflixertv.to",130],["myflixerz.*",130],["mylivestream.pro",130],["naijachoice.com.ng",130],["naijanowell.com",130],["netfilmes.org",130],["netizensbuzz.com",130],["niadd.com",130],["nizarstream.com",130],["noblocktape.*",[130,268]],["nowmaxtv.com",130],["nowsports.me",130],["nowsportv.nl",130],["odiasia.sbs",130],["ogomovies.*",130],["oii.io",130],["olalivehdplay.ru",130],["onepiecepower.com",130],["optimizepics.com",130],["pahe.plus",130],["pesktop.com",130],["pkspeed.net",130],["playgo1.cc",130],["poophq.com",[130,240]],["poscitechs.*",130],["project-free-tv.*",130],["qqwebplay.xyz",[130,240]],["radamel.icu",130],["rahim-soft.com",130],["reddit-soccerstreams.com",130],["repack-games.com",130],["rgeyyddl.*",130],["ronaldo7.pro",130],["s.to",[130,260]],["s3taku.com",130],["sbnmp.bar",130],["send.cm",[130,268]],["serienstream.*",130],["series2watch.*",130],["seriesonline.*",130],["shadowrangers.live",130],["shaheed4u.*",130],["share.filesh.site",130],["sharedisk.*",130],["shavetape.*",[130,261]],["shinden.pl",[130,301]],["shoot-yalla.live",130],["shortenlinks.top",130],["smoner.com",130],["soap2day-online.com",130],["soccerstream100.to",130],["sportsbuff.stream",130],["sportshub.*",130],["ssoap2day.*",[130,259]],["stfly.*",130],["strcloud.*",130],["streamcloud.*",130],["streamhd247.*",130],["streamnoads.com",130],["streamonsport99.*",130],["streamtape.*",[130,240,263]],["strtapewithadblock.*",130],["sulleiman.com",130],["swatchseries.*",130],["swiftload.io",[130,240]],["tamilprint30.*",[130,240]],["tapeadsenjoyer.com",130],["tapeadvertisement.com",130],["tapeantiads.com",130],["tapeblocker.com",130],["tapelovesads.org",130],["tapenoads.com",130],["tapewithadblock.org",130],["techgeek.digital",130],["temp.modpro.co",130],["thenextplanet1.*",130],["tii.la",130],["tnhitsda.net",130],["todaypk.*",130],["topcartoons.tv",130],["torovalley.net",130],["totalsportek.*",[130,240]],["trendytalker.com",130],["tvfutbol.info",130],["tvpclive.com",130],["up-4ever.net",130],["upbaam.com",130],["uploadhub.*",130],["uproxy.*",130],["uptomega.net",[130,240]],["usgate.xyz",[130,240]],["uupbom.com",130],["vadbam.net",130],["vavada5com.com",130],["vdbtm.shop",130],["veev.to",[130,240]],["vegamovie.*",130],["vid-guard.com",130],["vidcloud9.*",[130,261]],["videoplayer.*",130],["vido.*",130],["vidspeed.cc",130],["vidstreams.net",130],["vidtube.one",[130,240]],["viidshar.com",130],["vikistream.com",[130,260]],["vixcloud.co",[130,240]],["volokit2.com",[130,240]],["watchcartoononline.*",[130,509]],["watchmovierulz.*",130],["watchmovies.*",130],["watchomovies.*",[130,260]],["watchonlinemoviespk.*",130],["watchop.live",130],["wecast.to",130],["worldstreams.click",130],["xoxocomic.com",130],["xsportbox.com",130],["yesmovies4u.*",130],["yu2be.com",130],["zamundatv.com",130],["zoechip.cc",130],["zvision.link",130],["euro2024direct.ru",[130,485]],["stagatv.com",130],["stagatvfiles.com",130],["bingsport.xyz",130],["eurostreaming.casino",130],["sportsurge.net",130],["mlbbox.me",[130,240]],["easy-coin.*",132],["hackstore.me",133],["drivelinks.me",[134,135]],["hackshort.me",[134,135]],["freeserverhostingweb.club",[134,135,136]],["me-encantas.com",[134,135,136]],["mexicogob.com",[134,135,136]],["noticiascripto.site",[134,135,136]],["tanfacil.net",[134,135,136]],["tecnoaldia.net",[134,135,136]],["todoandroid.live",[134,135,136]],["sportshub.to",[134,430]],["dropmms.com",136],["pctfenix.*",[137,261]],["pctnew.*",[137,261]],["nextorrent.*",138],["pornfactors.com",138],["urlgalleries.net",139],["cambro.tv",140],["vipr.im",140],["dz4up1.com",141],["mexa.*",141],["ciudadgamer.com",142],["ovagames.com",143],["go.bucketforms.com",144],["sythe.org",[144,297]],["mz-web.de",145],["m.kuku.lu",146],["macrotrends.net",147],["lippycorn.com",148],["720pxmovies.blogspot.com",149],["oko.sh",150],["ratemyteachers.com",151],["isminiunuttum.com",151],["desiremovies.*",152],["notebookcheck-ru.com",153],["fc.lc",154],["fc-lc.com",154],["blog.40ch.net",154],["devotag.com",154],["uyduportal.net",154],["subedlc.com",154],["rosefile.net",154],["streameast.*",[155,240]],["sexvid.*",156],["hdtube.porn",156],["rat.xxx",156],["barefeetonthedashboard.com",[157,158]],["bargainbriana.com",[157,158]],["betterbuttchallenge.com",[157,158]],["bike-urious.com",[157,158]],["blwideas.com",[157,158]],["eartheclipse.com",[157,158]],["entertainment-focus.com",[157,158]],["fanatik.com.tr",[157,158]],["foreverconscious.com",[157,158]],["foreversparkly.com",[157,158]],["getdatgadget.com",[157,158]],["goodnewsnetwork.org",[157,158]],["greenarrowtv.com",[157,158]],["hbculifestyle.com",[157,158]],["heysigmund.com",[157,158]],["hodgepodgehippie.com",[157,158]],["homestratosphere.com",[157,158]],["indesignskills.com",[157,158]],["katiescucina.com",[157,158]],["knowyourphrase.com",[157,158]],["letsworkremotely.com",[157,158]],["lizs-early-learning-spot.com",[157,158]],["ledauphine.com",[157,158]],["leprogres.fr",[157,158]],["milliyet.com.tr",[157,158]],["mjsbigblog.com",[157,158]],["pinoyrecipe.net",[157,158]],["prepared-housewives.com",[157,158]],["redcarpet-fashionawards.com",[157,158]],["republicain-lorrain.fr",[157,158]],["savespendsplurge.com",[157,158]],["savingadvice.com",[157,158]],["shutupandgo.travel",[157,158]],["spring.org.uk",[157,158]],["stevivor.com",[157,158]],["tamaratattles.com",[157,158]],["tastefullyeclectic.com",[157,158]],["theavtimes.com",[157,158]],["thechroniclesofhome.com",[157,158]],["thisisourbliss.com",[157,158]],["tinyqualityhomes.org",[157,158]],["turtleboysports.com",[157,158]],["ultimateninjablazingx.com",[157,158]],["universfreebox.com",[157,158]],["utahsweetsavings.com",[157,158]],["vgamerz.com",[157,158]],["wheatbellyblog.com",[157,158]],["yummytummyaarthi.com",[157,158]],["closermag.fr",158],["seireshd.com",159],["pivigames.blog",160],["playpaste.com",161],["thecrazytourist.com",162],["pornult.com",163],["izzylaif.com",164],["gamefront.com",165],["interfans.org",165],["nirjonmela.com",165],["turkmmo.com",165],["washingtonpost.com",[166,167]],["bigwarp.*",[167,240]],["samash.com",168],["okanime.*",[169,260]],["arcadeprehacks.com",170],["iporntv.net",171],["xtapes.to",172],["lulustream.com",[172,250,277]],["lulustream.live",[172,250]],["luluvid.com",[172,240,250,277]],["yuvutu.com",173],["exey.io",[174,175,260]],["pornclassic.tube",176],["tubepornclassic.com",[176,177]],["voyeurhit.*",176],["upornia.*",176],["hotmovs.*",176],["thegay.*",176],["senzuri.tube",176],["txxxporn.tube",176],["hclips.com",176],["hdzog.*",176],["tuberel.com",176],["angelgals.com",178],["nakedbabes.club",178],["sexybabes.club",178],["cherrynudes.com",178],["hegreartnudes.com",178],["doseofporn.com",178],["secretsdujeu.com",179],["kisstvshow.*",180],["buffstreamz.com",181],["yepi.com",181],["playmyopinion.com",181],["megagames.com",182],["technews.tw",183],["bluedollar.net",183],["autopareri.com",183],["ffmovies.*",184],["officegamespot.com",185],["parzibyte.me",186],["fotografareindigitale.com",186],["theouterhaven.net",186],["watchallchannels.com",186],["wikipekes.com",186],["androgamer.org",186],["pugam.com",186],["guncelkaynak.com",186],["softwaresblue.com",187],["tapetus.pl",187],["mrpiracy.*",188],["faucetdump.com",189],["dropshipin.id",189],["techtobo.com",189],["jotapov.com",190],["jacksorrell.tv",190],["techilife.com",190],["ligainsider.de",191],["investmentwatchblog.com",192],["insidermonkey.com",192],["fangraphs.com",193],["allcalidad.*",[194,258]],["123anime.*",195],["listenonrepeat.com",196],["xiaomi-miui.gr",197],["photovoltaikforum.com",198],["robot-forum.com",198],["edealinfo.com",198],["soy502.com",199],["vttpi.com",200],["almezoryae.com",200],["arabic-robot.blogspot.com",200],["downloadsoft.net",200],["dafontvn.com",200],["tips97tech.blogspot.com",200],["osxinfo.net",201],["rangerboard.com",201],["bmw-scooters.com",201],["lewdcorner.com",201],["onlybabes.site",201],["admiregirls.su",201],["cardshare.biz",201],["kordramass.com",202],["kshowsubindo.org",202],["senimovie.co",202],["orirom.com",203],["romfirmware.com",203],["tatangga.com",203],["evileaks.*",204],["t-rocforum.de",204],["extreme-down.*",[205,206,259]],["tvchoicemagazine.co.uk",207],["hilites.today",207],["modebaca.com",208],["cuatrolatastv.blogspot.com",[209,264]],["pelispedia.*",210],["grid.id",211],["sfmcompile.club",213],["okulsoru.com",214],["onlinetutorium.com",214],["sakaiplus.com",214],["pghk.blogspot.com",214],["minemods.com.br",214],["freshstuff4u.info",214],["anoboy.*",214],["ministryofsolutions.com",214],["xiaomitools.com",214],["depo-program.blogspot.com",214],["texte.work",214],["linksaya.com",214],["moneywar2.blogspot.com",214],["dafideff.com",214],["tutoganga.blogspot.com",214],["link.cgtips.org",214],["gomaainfo.com",214],["acapellas.eu",214],["teknomuda.com",214],["walkthrough-indo.blogspot.com",214],["8tm.net",214],["tucsitupdate.blogspot.com",214],["pengantartidurkuh.blogspot.com",214],["whowantstuffs.blogspot.com",214],["decomaniacos.es",214],["garaveli.de",214],["rankersadda.in",214],["naijafav.top",214],["ourcoincash.xyz",214],["kiddyshort.com",214],["fellowsfilm.com",215],["netaffiliation.com",216],["spaziogames.it",217],["pg-wuming.com",217],["multics.eu",217],["forexforum.co",217],["tiz-cycling-live.io",218],["tiz-cycling.io",219],["cryptonetos.ru",220],["afreesms.com",220],["ogrenciyegelir.com",221],["iconmonstr.com",221],["theregister.co.uk",222],["wojtekczytawh40k.blogspot.com",223],["pharmaceutical-technology.com",224],["nosteam.ro",224],["semuanyabola.com",225],["freeiphone.fr",225],["safemodapk.com",225],["threezly.com",225],["truyenbanquyen.com",225],["veganinja.hu",225],["wikirise.com",225],["mobitool.net",225],["thecustomrom.com",225],["gamingvital.com",225],["dev2qa.com",225],["investnewsbrazil.com",226],["hentaipornpics.net",227],["2kspecialist.net",228],["kutubistan.blogspot.com",228],["softdroid4u.blogspot.com",228],["gbadamud.blogspot.com",228],["rppk13baru.blogspot.com",228],["arabamob.blogspot.com",228],["teachersguidetn.blogspot.com",228],["bayaningfilipino.blogspot.com",228],["akwam.*",[228,261]],["course-downloader.com",228],["digit77.com",229],["gudangfirmwere.com",230],["pelisxporno.net",231],["torresette.news",231],["hidefninja.com",231],["tryvaga.com",231],["myshopify.com",231],["epainfo.pl",231],["linkvertise.com",[232,233,234]],["wenxuecity.com",234],["mdn.lol",235],["crypto4yu.com",238],["manofadan.com",238],["readbitcoin.org",238],["set.seturl.in",239],["tpi.li",240],["oii.la",240],["stfly.biz",240],["airevue.net",240],["atravan.net",240],["0vg9r.com",240],["10hitmovies.com",240],["1flix.to",240],["1mov.lol",240],["2tamilprint.pro",240],["2024tv.ru",240],["7hitmovies.*",[240,260]],["9animetv.to",240],["9xmoovies.com",240],["advertisertape.com",240],["afilmywapi.biz",240],["alldownplay.xyz",240],["alphatron.tv",240],["andyday.*",240],["anime3rb.com",240],["animenexus.in",240],["animeunity.*",240],["animeyabu.org",240],["anisaga.org",240],["anitube.*",240],["aniwatchtv.to",240],["anroll.net",240],["aparttent.com",240],["apkship.shop",240],["arc018.to",240],["asd.*",240],["ask4movie.*",240],["ate60vs7zcjhsjo5qgv8.com",240],["avjosa.com",240],["bollydrive.*",[240,515]],["braflix.tube",240],["capo4play.com",240],["caq21harderv991gpluralplay.xyz",240],["cardboardtranslation.com",240],["cinedokan.top",240],["cloudnestra.com",240],["cloudy.pk",240],["cookiewebplay.xyz",240],["crackstreamsfree.com",240],["cuevana.pro",240],["curiosidadtop.com",240],["daddylivestream.com",240],["databasegdriveplayer.*",240],["demonicscans.org",[240,277]],["desicinema.org",240],["desicinemas.pk",240],["dlolcast.pro",240],["doods.to",240],["dorawatch.net",240],["dotflix.*",240],["drakorkita73.kita.rest",240],["dramanice.video",240],["driveup.space",240],["dudefilms.*",240],["ebook-hunter.org",240],["edgedeliverynetwork.com",240],["embasic.pro",240],["embedcanais.com",240],["embedtv.net",240],["embdproxy.xyz",240],["engstreams.shop",240],["enorme.tv",240],["eternalmangas.org",240],["fastdokan.*",240],["fastdownload.top",240],["filmyworlds.*",240],["filmyzilla5.com",240],["flixhd.cc",240],["fmoviesto.cc",240],["fojik.*",240],["footballstreams.lol",240],["footybite.*",240],["foreverquote.xyz",240],["frembed.*",[240,248]],["french-stream.*",240],["freshwaterdell.com",240],["fsportshd.net",240],["futemais.net",240],["fztvseries.ng",240],["gdflix.*",240],["gdriveplayer.*",240],["gidplayer.online",240],["giize.com",240],["goku.sx",240],["gomovies.pk",240],["hdfilme.*",[240,261]],["hakunamatata5.org",240],["hdtodayz.to",240],["hianime.*",240],["hoca2.com",240],["hoca6.com",240],["hoca4u.xyz",240],["hollymoviehd.cc",240],["hunterscomics.com",240],["ico3c.com",240],["joyousplay.xyz",240],["jxoplay.xyz",240],["kaa.mx",240],["kingstreamz.site",240],["lato.sx",240],["likemanga.ink",240],["linkmake.in",240],["linksheild.site",240],["lotusgamehd.xyz",240],["luckypatchers.com",240],["lulustream.*",240],["mapple.tv",[240,248]],["maxstream.*",240],["mcloud.guru",240],["medeberiya.site",240],["mega4upload.net",240],["messitv.org",240],["mh.baxoi.buzz",240],["mlbb.space",240],["mlfbd.*",240],["movieku.ink",240],["movielair.cc",240],["movielinkbdofficial.com",240],["movies123.pk",240],["moviesapi.to",[240,277]],["movieshdwatch.to",240],["movieshubweb.com",240],["moviesnation.*",240],["movies2watch.*",240],["myflixerz.to",240],["nbabite.to",240],["nexdrive.*",240],["neymartv.net",[240,260]],["nflbite.to",240],["nmac.to",240],["ogoplayer.xyz",240],["olympustaff.com",240],["omuzaani.me",240],["onlinekosh.com",240],["pahe.*",240],["pelisflix2.*",240],["pkembed.*",240],["player.smashy.stream",[240,469]],["playerflixapi.com",240],["pondit.xyz",240],["popcornmovies.org",240],["poscitechs.lol",240],["pressplay.cam",240],["pressplay.top",240],["reddit-streams.online",240],["reliabletv.me",240],["riedberg.tv",240],["ripplestream4u.*",240],["rojadirectaenhd.net",240],["s2watch.link",240],["seeflix.to",240],["sflix.*",240],["shazysport.pro",240],["shopr.tv",240],["showflix.*",240],["skysetx.*",240],["snowmtl.ru",240],["souq-design.com",240],["spcdn.xyz",240],["sportingsurge.com",240],["sportsgames.today",240],["sportshub.stream",240],["sportsloverz.xyz",240],["spotifylists.com",240],["storynavigation.com",240],["strcloud.in",240],["streamblasters.*",240],["streambtw.com",[240,521]],["streamed.su",240],["streamfree.to",240],["streaming-community.*",240],["streamingcommunityz.*",240],["streamingunity.to",240],["streamlivetv.site",240],["streamlord.com",240],["streamta.site",240],["strmup.to",[240,515]],["subtitlecat.com",240],["swfr.tv",240],["tamilprint29.*",240],["tamilprint31.*",240],["tapepops.com",[240,263]],["telepisodes.org",240],["tfp.is",240],["thedaddy.*",240],["theflixertv.to",[240,277]],["thehesgoal.com",240],["tinyzonetv.cc",240],["topembed.pw",240],["tous-sports.ru",240],["tutvlive.ru",240],["tvableon.me",240],["tvsportslive.fr",240],["updown.cam",240],["ustream.to",240],["uqload.*",240],["vcloud.lol",240],["vecloud.eu",240],["vegamovies4u.*",240],["veplay.top",240],["video-seed.xyz",240],["vidora.stream",[240,277]],["vidzy.org",240],["vinovo.to",[240,413]],["vodkapr3mium.com",240],["watch.ug",240],["watch32.sx",240],["watchadsontape.com",240],["watchf1full.com",240],["watchonlinemovie.pk",240],["watchonlinemovies.vercel.app",240],["watchseries8.to",240],["watchug.to",240],["way2movies.*",240],["wdpglobal.com",240],["weakstreams.online",240],["wmovies.xyz",240],["xcloud.*",240],["y2mate.*",240],["yomovies.*",240],["yoxplay.xyz",240],["ythd.org",240],["yuppow.com",240],["zjet7.com",240],["zorroplay.xyz",240],["nekopoicare.*>>",240],["novizer.com>>",240],["ssyou.tube",240],["y2meta-uk.com",240],["filemoon.*>>",240],["96ar.com>>",240],["designparty.sx>>",240],["iqksisgw.xyz>>",240],["u6lyxl0w.skin>>",240],["ww9g.com>>",240],["nptsr.live>>",240],["4bct9.live>>",240],["xztgl.com>>",240],["remilf.xyz>>",240],["filehost9.com>>",240],["ilovetoplay.xyz",240],["quest4play.xyz",240],["streamcaster.live",240],["weblivehdplay.ru",240],["crichd-player.top",240],["crichdplays.ru",240],["lolcalhost.ru",240],["playtube.tv",240],["filmyfly.*",240],["playeriframe.lol>>",240],["0ochi8hp.com",240],["animefire.info",240],["animesonlinecc.us",240],["animesonliner4.com",240],["animesup.info",240],["animeyabu.net",240],["anitube.us",240],["anitube.vip",240],["caroloportunidades.com.br",240],["dattebayo-br.com",240],["file4go.com",240],["flyanimes.cloud",240],["goanimes.vip",240],["goyabu.us",240],["hinatasoul.com",240],["isekaibrasil.com",240],["meuanime.info",240],["otakuanimess.net",240],["superanimes.in",240],["buffsports.*",240],["fbstreams.*",240],["strikeout.im",240],["wavewalt.me",240],["bflix.*>>",240],["daddylive.*>>",240],["daddylivestream.com>>",240],["dlhd.*>>",240],["thedaddy.*>>",240],["forgee.xyz",240],["gamehub.cam",240],["watchserieshd.stream>>",240],["freestreams-live.*>>",240],["compu-pc.com",241],["nxprime.in",242],["theuser.cloud",243],["foodtechnos.in",244],["tagecoin.com",[244,429]],["claimsatoshi.xyz",244],["harshfaucet.com",244],["mcafee-com.com",244],["141jav.com",245],["moviesjoy-to.*",245],["txxx.*",246],["vxxx.com",247],["pornhits.com",247],["vidfast.*",[248,277]],["gaygo.tv",249],["bunkr-albums.io",250],["saint2.cr",250],["mitaku.net",250],["xmoviesforyou.*",250],["lewdzone.com",250],["mangaplus.shueisha.tv",252],["shueisharaw.tv",252],["tunemovie.fun",253],["brocoflix.com",254],["brocoflix.xyz",254],["coinsbomb.com",255],["daemon-hentai.com",[255,279]],["everia.club",255],["kurakura21.com",255],["tophentaicomics.com",256],["erotic-beauties.com",256],["hardsex.cc",256],["sex-movies.biz",256],["sikwap.xyz",256],["tube18.sexy",256],["activevoyeur.com",257],["allbbwtube.com",257],["alltstube.com",257],["cockmeter.com",257],["18-teen-sex.com",257],["18-teen-tube.com",257],["18girlssex.com",257],["18teen-tube.com",257],["18tubehd.com",257],["2017tube.com",257],["sexmoza.com",257],["yogranny.com",257],["youfreepornotube.com",257],["zhlednito.cz",257],["33sk.*",258],["3sk.*",258],["4shared.com",258],["anime-odcinki.pl",258],["animesvision.*",258],["bdcraft.net",258],["best4hack.blogspot.com",258],["biqle.com",258],["bmovie.*",258],["cinedetodo.*",258],["cinetux.*",258],["descargas2020.*",258],["exyi.net",258],["fmovie.*",258],["hitokin.net",258],["iptvdroid1.blogspot.com",258],["ironysub.*",258],["janjua.*",258],["kstreaming.*",258],["langitmovie.com",258],["libertyvf.*",258],["movieloversworld.com",258],["nensaysubs.net",258],["nflbite.com",258],["onlystream.tv",258],["popcornstream.*",258],["saveshared.com",258],["shorten.*",258],["solarmovie.*",258],["storieswatch.com",258],["streamango.*",258],["streaming-one.com",258],["streamloverx.com",258],["turkanime.*",258],["uploadev.*",258],["ur-files.com",258],["vidoza.net",258],["vidshare.tv",258],["watchtrailerparkboys.com",258],["xmovies08.*",258],["1111fullwise.*",259],["111watcho.*",259],["123-movies.*",259],["123moviesc.*",259],["123moviesla.*",259],["1kmovies.*",259],["2gomovies.*",259],["4filmyzilla.*",259],["69hoshudaana.*",259],["adshort.*",259],["airportseirosafar.com",259],["ajkalerbarta.com",[259,260]],["akmcloud.*",259],["allmovieshub.*",259],["altadefinizione01.*",[259,260]],["animetak.*",259],["animeworld.tv",259],["appsfree4u.com",[259,260]],["appvn.com",259],["arenavision.*",259],["askim-bg.com",259],["b-bmovies.com",259],["baixedetudo.net.br",259],["baramjak.com",259],["batmanstream.*",259],["bclikeqt.com",259],["bengalisite.com",[259,260]],["bollymovies.*",259],["bollywoodfilma.*",259],["buffstream.*",259],["ch-play.com",[259,260]],["charexempire.com",259],["clampschoolholic.*",259],["comandotorrenthd.org",259],["comofuncionaque.com",259],["crackevil.com",[259,349]],["crichd.*",259],["crictime.*",259],["cryptoforu.org",259],["deportealdia.live",259],["dflinks.*",259],["downloadming.*",259],["dramacool.*",259],["e123movies.com",259],["eio.io",259],["europix.*",259],["exe.app",259],["exee.io",259],["f1stream.*",[259,260,261]],["fbstream.*",[259,260,261]],["fffmovies.*",259],["filme-bune.biz",259],["filmisongs.*",259],["filmovi.ws",259],["flixhq.ru",259],["foumovies.*",259],["fullcinema.*",259],["fullreal.*",259],["fulltube.*",259],["getmega.net",259],["givemenbastreams.com",259],["gnula.*",259],["gogoplay.*",259],["gomo.to",259],["gyonlineng.com",259],["hd44.net",259],["hdmoviehubs.*",259],["hdmovies23.com",259],["hdonline.co",259],["hdpopcorns.*",259],["hdss-to.*",259],["hdzone.org",259],["healthnewsreel.com",[259,260]],["i123movies.net",259],["iegybest.co",259],["ikindlebooks.com",259],["illink.net",259],["isaimini.ca",259],["iv-soft.com",[259,260]],["jalshamoviezhd.*",259],["janjua.tv",259],["jewelry.com.my",[259,260]],["jkanime.*",259],["johnwardflighttraining.com",[259,260]],["kabarportal.com",[259,260]],["keepv.id",259],["keepvid.*",259],["kiss-anime.*",259],["kissanime.*",[259,262]],["kissmanga.*",259],["kstorymedia.com",[259,260]],["kumascans.com",259],["la123movies.org",259],["leet365.cc",[259,260]],["lespassionsdechinouk.com",[259,260]],["libertestreamvf.*",[259,260]],["linkshere.*",259],["linksmore.*",259],["live7v.com",259],["livestreamtv.pk",[259,260]],["lodynet.*",259],["lookmovie.*",259],["lookmovie186.*",259],["lookmoviess.com",259],["losmovies.*",259],["manga4life.com",259],["mangasco.com",259],["mangceh.cc",259],["masengwa.com",259],["mcdlpit.com",259],["mega-mkv.com",259],["mega-p2p.net",259],["megafilmeshd20.*",259],["megashare-website.com",259],["mettablog.com",259],["mlbstream.*",[259,260,261]],["momomesh.tv",259],["motive213link.blogspot.com",259],["motogpstream.*",[259,260,261]],["movierulzhd.*",[259,339]],["movies7.to",259],["moviesbaba.*",259],["moviescounter.*",259],["mp3-gratis.it",259],["mp3spy.cc",259],["myegy.*",259],["myfernweh.com",[259,260]],["naasongs.*",259],["naasongsfree.*",259],["nbastream.*",[259,260,261]],["nflstream.*",[259,260,261]],["ngomik.net",[259,260]],["nhlstream.*",[259,260,261]],["nmovies.cc",259],["novamovie.net",259],["novelssites.com",259],["oceanofmovies.*",259],["onlinevideoconverter.*",259],["oploverz.*",[259,473]],["orangeink.pk",[259,260]],["ostreaming.tv",259],["pagalworld.*",259],["pelismart.com",259],["pelisstar.com",259],["pirlotv.mx",259],["playerfs.com",259],["playtamil.*",259],["plylive.*",[259,260]],["primewire.*",259],["projectfreetv2.com",259],["putlocker9.*",259],["putlockers.*",[259,260]],["querofilmehd.*",259],["romfast.com",[259,261]],["rugbystreams.*",[259,260,261]],["sdmoviespoint.*",259],["serijehaha.com",[259,260]],["sharkfish.xyz",259],["shortlinkto.*",259],["simsdom.com",259],["skidrow-games.com",259],["sportstreamtv.*",259],["stream.pkayprek.com",259],["talaba.su",[259,260]],["tamilyogis.*",259],["tatabrada.tv",[259,260]],["tenies-online.*",259],["tgo-tv.co",259],["thelinkbox.*",259],["thesuperdownload.*",259],["thingstomen.com",259],["thripy.com",[259,260]],["tlin.me",259],["tvply.*",[259,260]],["u123movies.com",259],["ufcstream.*",[259,260,261]],["ukmagazinesfree.com",259],["uppit.com",[259,264]],["urdubolo.pk",[259,260]],["usagoals.*",259],["vedbom.*",259],["veryfastdownload.pw",259],["vevioz.com",259],["vidbeem.com",259],["vidbm.com",259],["vidcorn.to",259],["vidembed.*",259],["vidlo.us",259],["vkmp3.*",259],["wat32.tv",259],["watchmovieshd.*",259],["watchserieshd.*",259],["watchseriesstream.com",259],["wawacity.*",259],["wifi4games.com",259],["wildwap.*",259],["wmoviesfree.*",259],["xmovies8.*",259],["xxxwebdlxxx.top",259],["yeshd.net",259],["yesmovies.*",259],["yt1s.com",259],["ytsaver.*",259],["ziperto.com",[259,268]],["123movies-official.net",260],["123movies.net",260],["123movies4up.*",260],["123moviesme.*",260],["123moviesready.org",260],["4stream.*",260],["5xmovies.*",260],["720pstream.*",260],["9tsu.*",260],["9xmovie.*",260],["9xupload.*",260],["allosoccer.com",260],["anavidz.com",260],["anidl.org",260],["anime-sanka.com",260],["anime4up.*",260],["animefreak.*",260],["animesanka.*",260],["animesup.*",260],["apkmody.io",260],["apkshrt.com",260],["asianhdplay.net",260],["asianplay.*",260],["asianwatch.net",260],["bakotv.com",260],["bdmusic23.*",260],["bhplay.me",260],["bx-zone.com",260],["canonprintersdrivers.com",260],["cat-a-cat.net",260],["ccnworldtech.com",260],["cheat.hax4you.net",260],["cima100fm.com",260],["clipconverter.cc",260],["crystal-launcher.pl",260],["distanta.net",260],["dtmaga.com",260],["elevationmap.net",260],["eplayvid.*",260],["fakazagods.com",260],["fastilinks.*",260],["fboxtv.com",260],["fightforthealliance.com",260],["fileguru.net",260],["filma1.*",260],["filma24.*",260],["filmy.*",260],["filmyhit.*",260],["flixtor.*",260],["freeromsdownload.com",260],["g3g.*",260],["gameslay.net",260],["gdplayer.*",260],["gentlewasher.com",260],["gofilmes.*",260],["gogoplay1.com",260],["gogoplay2.com",260],["gomoviz.*",260],["govid.*",260],["hds-streaming-hd.com",260],["hds-streaming.*",260],["hentaizm.fun",260],["hhdmovies.*",260],["hikarinoakari.com",260],["hilaryhahn.com",260],["hindimovies.*",260],["hothit.me",260],["hotmasti.*",260],["ilgeniodellostreaming.*",260],["ilinks.in",260],["imgspark.com",260],["insurancebillpayment.net",260],["intereseducation.com",260],["jetanimes.*",260],["joolinks.*",260],["jpscan-vf.com",260],["katlinks.*",260],["katmoviehd4.com",260],["kimoitv.com",260],["kingdomfiles.com",260],["liflix.site",260],["linksfire.*",260],["linksly.co",260],["lustholic.com",260],["mangahere.today",260],["manganatos.com",260],["manhuascan.*",260],["manhwa68.com",260],["melodelaa.*",260],["messitv.net",260],["mkvcage.*",260],["mkvpapa.*",260],["mobdropro.com",260],["modsfire.com",260],["moonblinkwifi.com",260],["moshahda.net",260],["motive213.com",260],["moviedekho.in",260],["moviefreak.*",260],["moviescounnter.com",260],["moviesdaweb.*",260],["moviesland.*",260],["moviewr.com",260],["mp3-now.com",260],["mp3fromyou.tube",260],["mp3juices.su",260],["mp3yeni.org",260],["mycima.*",260],["networklovers.com",260],["nkiri.com",260],["novelroom.net",260],["ogario.*",260],["okamimiost.com",260],["paidnaija.com",260],["pelismarthd.com",260],["pelismartv.com",260],["pelispoptv.com",260],["pirate4all.com",260],["plyvdo.*",260],["put-locker.com",260],["putingfilm.com",260],["quiltfusion.com",260],["rawkuma.com",260],["redowlanalytics.com",260],["roms-download.com",260],["roms-hub.com",260],["roms-telecharger.com",260],["serien.cam",260],["serienstream.to",260],["series9.*",260],["sflix.pro",260],["shadowrangers.*",260],["showbizbites.com",260],["shrink.*",260],["shrugemojis.com",260],["southfreak.*",260],["ssrmovies.*",260],["stardima.*",260],["stopstreamtv.net",260],["streambee.to",260],["streamsport.*",260],["t7meel.*",260],["tamilarasan.*",260],["tamilfreemp3songs.*",260],["tamilprint.*",260],["tamilprinthd.*",260],["tcpermaculture.com",260],["techmyntra.net",260],["techsslash.com",260],["thelosmovies.com",260],["thememypc.net",260],["thevideome.com",260],["thewatchseries.live",260],["topflix.*",260],["totallyfuzzy.net",260],["traveldesearch.com",260],["tubidy.*",260],["tudotecno.com",260],["turkish123.com",260],["uctnew.com",260],["upload-4ever.com",260],["uploadmx.com",260],["uploadrar.*",260],["uploads.mobi",260],["uptobhai.*",260],["uptoimage.com",260],["upvid.*",260],["uwatchfree.*",260],["vanime.*",[260,263]],["vbox7-mp3.info",260],["vf-film.net",260],["vibehubs.com",260],["vipstand.se",260],["viralitytoday.com",260],["voiranime.stream",260],["warefree01.com",260],["watch4hd.*",260],["watchdoctorwhoonline.com",260],["watchimpracticaljokers.com",260],["watchmovie.*",260],["watchtheofficetv.com",260],["web.livecricket.is",260],["webloadedmovie.com",260],["whatshowto.com",260],["wintub.com",260],["world4ufree1.*",260],["worldgreynews.com",260],["wupfile.com",260],["y-2mate.com",260],["yomoviesnow.com",260],["yoyofilmeys.*",260],["yseries.tv",260],["ytconverter.app",260],["ytmp3cc.net",260],["ytmp4.live",260],["ytmp4converter.com",260],["01234movies.*",261],["1234movies.*",261],["123gostream.*",261],["123moviesgo.*",261],["123moviestoday.net",261],["1link.club",261],["1primewire.com",261],["1stkissmanga.*",261],["1tamilmv.*",[261,360]],["8-ball-magic.com",261],["adcorto.*",261],["adsh.cc",261],["afilmyhouse.blogspot.com",261],["aii.sh",261],["animehay.tv",261],["animeheaven.ru",261],["arnaqueinternet.com",261],["asianload.*",261],["ate9ni.com",261],["bdiptv.*",261],["beammeup.com.au",261],["bitlinks.pw",261],["bollyshare.*",261],["ccurl.net",261],["ceesty.com",261],["cinen9.*",261],["citpekalongan.com",261],["claimcrypto.cc",261],["clkmein.com",261],["comandotorrentshds.org",261],["corneey.com",261],["crazyblog.in",261],["cuevana3.*",261],["destyy.com",261],["dogecoin.*",261],["dramanice.*",261],["earnload.*",261],["eastream.net",261],["ed-protect.org",261],["fakaza.com",261],["festyy.com",261],["filmesonlinex.*",261],["filmy4wap1.*",261],["filmyone.com",261],["freelitecoin.vip",261],["freeload.*",261],["fzmovies.*",261],["gdirect.*",261],["gestyy.com",261],["gogoanimes.*",261],["gulf-up.com",261],["hd44.com",261],["hdstreamss.club",261],["hindimoviesonline.*",261],["hostxy.com",261],["iiyoutube.com",261],["inextmovies.*",261],["japscan.ws",261],["linkskat.*",261],["mailnesia.com",261],["mangaindo.web.id",261],["mega4up.*",261],["megaup.net",261],["mkvhub.*",261],["movies4me.*",261],["moviesmon.*",261],["moviesshub.*",261],["moviessquad.com",261],["moviesub.is",261],["movizland.*",261],["mozkra.com",261],["mp3cristianos.net",261],["mp3songsdownloadf.blogspot.com",261],["naijahits.com",261],["naijal.com",261],["nbch.com.ar",261],["nowmovies.*",261],["ocnpj.com",261],["octanime.net",261],["openload.*",261],["phc.web.id",261],["plusupload.*",261],["pregledaj.net",261],["primeflix.website",261],["r2sa.net",261],["racaty.*",261],["readingbd.com",261],["receitasoncaseiras.online",261],["recetas.arrozconleche.info",261],["revivelink.com",261],["rojadirecta.*",261],["rojadirectatv.*",261],["s2dfree.*",261],["seriesflv.*",261],["seriesly.*",261],["seuseriado.*",261],["sh.st",261],["shortpaid.com",261],["stalkface.com",261],["strtapeadblock.*",[261,263]],["summarynetworks.com",261],["supervideo.tv",261],["tajpoint.com",261],["techrecur.com",261],["theismailiusa.org",261],["thekingavatar.com",261],["thenetnaija.co",261],["tny.so",261],["upfiles.*",261],["vdtgr.com",261],["vedshar.com",261],["vidcloudpng.com",261],["vidomo.xyz",261],["vidsaver.net",261],["wildwap.com",261],["worldgirlsportal.com",261],["xmovies.*",261],["xsanime.com",261],["ymovies.*",261],["ymp4.download",261],["youtubeai.com",261],["youtubetoany.com",261],["youwatch.*",261],["zone-annuaire.*",261],["zplayer.live",261],["0123movies.*",262],["2conv.com",262],["anonymous-links.com",262],["bdupload.*",262],["dl-protect.*",262],["dl-protect1.*",262],["doctor-groups.com",262],["egyanime.com",262],["filmesonlinehd1.org",262],["firstonetv.*",262],["flvto.biz",262],["goalup.live",262],["gomovieshub.io",262],["gplinks.co",262],["hdmovieplus.*",262],["hydracdn.*",262],["linkshorts.*",262],["mangamanga.*",262],["modapkfile.com",262],["movieshub.*",262],["movs4u.*",262],["multifaucet.org",262],["nbaup.live",262],["o2tvseries.website",262],["pewgame.com",262],["q1-tdsge.com",262],["readm.org",262],["shortearn.*",262],["shrlink.top",262],["shugraithou.com",262],["sports24.*",262],["vexfile.com",262],["vexmovies.*",262],["vidlox.*",262],["yesmovies123.me",262],["yifysubtitles.*",262],["adblockstreamtape.*",263],["adblockstrtape.*",263],["adblockstrtech.*",263],["komikcast.*",263],["mavanimes.*",263],["stape.*",263],["streamadblockplus.*",263],["streamta.*",263],["streamtapeadblock.*",263],["strtape.*",263],["strtpe.*",263],["123moviesonline.*",264],["2embed.*",264],["adblockeronstape.*",264],["brbushare.*",264],["direct-cloud.me",264],["driveup.in",264],["filmeseries.*",264],["goved.org",264],["hdmovies2.org",264],["hdmovies50.*",264],["seriezloaded.com.ng",264],["skymovieshd.*",264],["slink.bid",264],["stapewithadblock.*",264],["upbam.org",264],["uplinkto.*",264],["vadbam.com",264],["vadbom.com",264],["vedbam.*",264],["vidbam.org",264],["vidshar.org",264],["filecrypt.*",265],["mediacast.click",265],["playcast.click",265],["egydead.*",266],["arabseed.*",267],["liiivideo.com",267],["seeeed.*",267],["adblockeronstreamtape.*",268],["cloudvideo.tv",268],["cloudvideotv.*",268],["hiphopa.net",268],["torrentmac.net",268],["pepperlive.info",269],["up4stream.com",271],["filmisub.cc",272],["chaturflix.cam",273],["niyaniya.moe",273],["pawastreams.pro",[274,279]],["hyhd.org",275],["playfa.com",276],["123animehub.cc",277],["123animes.ru",277],["actvid.*",277],["boosterx.stream",277],["cataz.to",277],["cineb.rs",277],["cineb.gg",277],["dopebox.to",277],["fbsquadx.com",277],["flixhq.to",277],["gomoviestv.to",277],["himovies.sx",277],["hurawatch.cc",277],["jkanime.net",277],["lectormangaa.com",277],["limetorrents.lol",277],["mangagun.net",277],["mexa.sh",277],["mgeko.cc",277],["moflix-stream.fans",277],["motchill29.com",277],["mov18plus.cloud",277],["movies2watch.tv",277],["musichq.cc",277],["netmovies.to",277],["readcomiconline.*",277],["seriesonline.sx",277],["torrentdownload.*",[277,322,471]],["toonily.com",277],["torrentdownloads.*",[277,322]],["tukipasti.com",277],["updown.icu",277],["vidsrc.cc",277],["watchasians.cc",277],["watch-movies.com.pk",277],["zoechip.com",277],["zoechip.gg",277],["thecakeboutiquect.com",278],["cgcosplay.org",278],["onmsft.com",280],["audiotools.pro",281],["audizine.com",281],["blackenterprise.com",281],["cheatsheet.com",281],["cwtv.com",281],["magesy.*",281],["pastes.io",281],["autonews.com",282],["cnet.com",282],["inc.com",282],["mtv.com",282],["polygon.com",282],["prydwen.gg",282],["theverge.com",282],["vox.com",282],["weather.com",282],["wunderground.com",282],["zdnet.com",282],["androidpolice.com",282],["carbuzz.com",282],["cbr.com",282],["collider.com",282],["dualshockers.com",282],["eater.com",282],["gamerant.com",282],["howtogeek.com",282],["makeuseof.com",282],["movieweb.com",282],["screenrant.com",282],["thegamer.com",282],["worldstar.com",282],["worldstarhiphop.com",282],["xda-developers.com",282],["auone.jp",283],["biblegateway.com",283],["blogmura.com",283],["deckshop.pro",283],["gamewith.jp",283],["gruene-zitate.de",283],["jmty.jp",283],["kr-weathernews.com",283],["laposte.net",283],["motor-talk.de",283],["myforecast.com",283],["newser.com",283],["nikkan-gendai.com",283],["picks.my",283],["reneweconomy.com.au",283],["signupgenius.com",283],["slickdeals.net",283],["smithsonianmag.com",[283,492]],["thefreebieguy.com",283],["worldhistory.org",283],["zerogpt.com",283],["saabcentral.com",283],["mixdrop.*",284],["mixdrp.*",284],["idnes.cz",285],["alleveilingen.be",286],["alleveilingen.nl",286],["isgfrm.com",287],["joymaxtr.net",288],["hdfilmizlesen.com",289],["sieutamphim.me",290],["vozer.io",291],["vozer.vn",291],["helpnetsecurity.com",292],["techieway.blogspot.com",293],["desktophut.com",294],["getitfree.cn",294],["techably.com",295],["minorpatch.com",296],["wg-gesucht.de",298],["okhatrimaza.*",299],["mirrorace.com",300],["supermarches.ca",302],["punisoku.blogo.jp",303],["smartwebsolutions.org",304],["turkrock.com",304],["taigoforum.de",304],["gtamaxprofit.com",305],["linfoweb.com",306],["cracking.org",[307,308]],["lomcn.org",307],["aroratr.club",308],["labelotaku.com",309],["gsmfirmware.net",309],["rumahit.id",309],["miuiku.com",309],["softwaresde.com",310],["artesacro.org",311],["takimag.com",312],["hollywoodpq.com",313],["youranshare.com",314],["freewatchserialonline.com",315],["fshost.me",317],["eddiekidiw.com",318],["hdporn92.com",319],["linuxhint.com",320],["thekitchenmagpie.com",320],["newsiqra.com",321],["proxybit.*",322],["grosnews.com",322],["unblocked.name",322],["sharegdrive.com",322],["uproxy2.biz",322],["br0wsers.com",323],["playsexgames.xxx",324],["cryptowin.io",325],["sexflashgame.org",326],["filtercams.com",327],["elvocero.com",328],["freepornxxxhd.com",329],["okteve.com",332],["zdravenportal.eu",334],["shooshtime.com",335],["bittools.net",336],["imginn.com",337],["linkpoi.me",338],["freevstplugins.net",339],["insidertracking.com",340],["forobasketcatala.com",341],["dndsearch.in",342],["chapteria.com",343],["samfw.com",345],["ibooks.to",346],["fantasyfootballgeek.co.uk",346],["mrunblock.*",347],["gifans.com",348],["filmyhitlink.xyz",349],["flightsim.to",[350,351]],["cinemakottaga.*",352],["nudes7.com",352],["wgod.co",353],["tutflix.org",353],["tamilbrahmins.com",353],["milanworld.net",353],["arabincest.com",353],["archpaper.com",354],["justcastingporn.com",355],["justfamilyporn.com",355],["userload.*",356],["fapnado.*",357],["pclicious.net",358],["dsocker1234.blogspot.com",361],["ceylonssh.com",362],["liveonsat.com",363],["luckydice.net",365],["mytoolz.net",366],["alphagames4u.com",367],["freexcafe.com",368],["studybullet.com",369],["superpsx.com",369],["chicagobearshq.com",370],["chicagobullshq.com",370],["chicagosportshq.com",370],["cubshq.com",370],["tigernet.com",370],["lootup.me",371],["learnclax.com",372],["newsmondo.it",373],["helpdice.com",374],["techsignin.com",376],["osmanonline.co.uk",377],["sarapbabe.com",378],["lbprate.com",379],["katmoviehd.*",379],["virpe.cc",380],["lover937.net",[380,499]],["btcadspace.com",381],["pherotruth.com",382],["vtube.to",383],["prepostseo.com",384],["order-order.com",385],["cacfutures.org",386],["comexlive.org",386],["daxfutures.org",386],["dollarindex.org",386],["dowfutures.org",386],["ftsefutures.org",386],["mcxlive.org",386],["nasdaqfutures.org",386],["ncdexlive.org",386],["niftyfutures.org",386],["nikkeifutures.org",386],["sgxnifty.org",386],["spfutures.org",386],["learnmania.org",387],["gamingforecast.com",389],["drawize.com",390],["hindimovies.to",391],["alycia-debnam-carey.com",392],["christinaricci.net",392],["emmy-rossum.com",392],["natalie-portman.org",392],["rachel-brosnahan.org",392],["111.90.150.10",393],["111.90.141.252",393],["entireweb.com",394],["babia.to",395],["racedepartment.com",395],["r3owners.net",395],["hentaimoe.me",396],["111.90.150.149",397],["111.90.151.26",397],["currencyconverterx.com",398],["apkmodhub.in",399],["faucetcrypto.net",400],["valeronevijao.com",401],["yodelswartlike.com",401],["generatesnitrosate.com",401],["gamoneinterrupted.com",401],["metagnathtuggers.com",401],["rationalityaloelike.com",401],["sizyreelingly.com",401],["urochsunloath.com",401],["monorhinouscassaba.com",401],["antecoxalbobbing1010.com",401],["boonlessbestselling244.com",401],["cyamidpulverulence530.com",401],["guidon40hyporadius9.com",401],["449unceremoniousnasoseptal.com",401],["30sensualizeexpression.com",401],["greaseball6eventual20.com",401],["toxitabellaeatrebates306.com",401],["20demidistance9elongations.com",401],["audaciousdefaulthouse.com",401],["fittingcentermondaysunday.com",401],["launchreliantcleaverriver.com",401],["matriculant401merited.com",401],["realfinanceblogcenter.com",401],["telyn610zoanthropy.com",401],["un-block-voe.net",401],["v-o-e-unblock.com",401],["voe-un-block.com",401],["voe-unblock.*",401],["voeunbl0ck.com",401],["voeunblck.com",401],["voeunblk.com",401],["voeunblock.com",401],["voeunblock2.com",401],["voeunblock3.com",401],["givee.club",402],["erome.com",403],["missav.*",404],["missav123.com",404],["missav888.com",404],["angelfire.com",405],["erotom.com",406],["vrporn.com",407],["vidsrc.click",408],["filemoon-59t9ep5j.xyz",409],["filemoon-nv2xl8an.xyz",409],["ps2-bios.com",411],["odum.cl",412],["helmiau.com",413],["coolrom.com.au",414],["ksl.com",415],["bang14.com",416],["komputerswiat.pl",417],["tokuvn.com",418],["kpopjams.com",419],["thiepmung.com",420],["rlxtech24h.com",421],["emsnow.com",422],["bagpipe.news",422],["ckxsfm.com",422],["msmorristown.com",422],["durhamopenhouses.com",422],["careersatcouncil.com.au",422],["sexjobs.es",423],["cloud-computing-central.com",424],["nudostar.com",425],["shesfreaky.com",426],["hentaibatch.com",426],["hentaihaven.vip",427],["nhentaihaven.org",427],["xhvid1.com",428],["financialjuice.com",431],["n.fcd.su",433],["archiwumalle.pl",435],["gloryshole.com",436],["hentaikai.com",438],["telesrbija.com",439],["xxxtik.com",440],["xpornium.net",441],["fc2stream.tv",441],["mycloudz.cc",441],["photooxy.com",442],["bunkr.la",443],["hdrez.com",444],["lgwebos.com",445],["sociologicamente.it",446],["burbuja.info",447],["aliendictionary.com",448],["proverbmeaning.com",448],["tudongnghia.com",448],["vietnamanswer.com",448],["telorku.xyz",449],["chat.tchatche.com",450],["hentaibooty.com",451],["nicekkk.com",452],["hes-goals.*",453],["av01.media",454],["decorisi.com",455],["expertplay.net",456],["udemy-downloader.com",457],["myvidster.com",458],["ggjav.com",459],["ggjav.tv",459],["ecamrips.com",[460,461]],["showcamrips.com",[460,461]],["cimanow.cc",462],["freex2line.online",462],["whoreshub.com",463],["cryptoclicks.net",464],["sonixgvn.net",465],["paste-drop.com",466],["db-creation.net",467],["imagefap.com",468],["player.smashystream.com",469],["fmovies.*",470],["file-up.org",472],["timesnewsgroup.com.au",473],["mangaku.*",474],["carbonite.co.za",476],["m.akkxs.net",477],["bailiwickexpress.com",478],["tv.bdix.app",479],["deano.me",480],["themehospital.co.uk",480],["resplace.com",480],["daotranslate.*",481],["tainguyenmienphi.com",482],["ripleyfieldworktracker.com",483],["iggtech.com",484],["asia.5ivttv.vip",484],["uiiumovie.*",486],["sport890.com.uy",490],["pornwex.tv",491],["pianetalecce.it",493],["decompiler.com",494],["crackshash.com",495],["zone-telechargement.ing",496],["x-video.tube",497],["vidlink.pro",498],["111movies.com",498],["456movie.com",498],["moviedokan.*",500],["videovak.com",501],["cambro.io",502],["fileplanet.com",503],["wvt.free.nf",504],["hotgirlpix.com",505],["mma-core.*",506],["ignboards.com",507],["watchcartoonsonline.*",509],["wcostream.*",509],["futbolsayfasi.net",510],["netronline.com",511],["moviediskhd.cloud",512],["comdotgame.com",513],["abstream.to",514],["royale-games.com",516],["gleaks.pro",517],["whoisnovel.com",518],["videezy.com",519],["onlyssh.my.id",520],["whyvpn.my.id",520],["omegascans.org",523],["jav.sb",524],["business-standard.com",525],["uindex.org",526],["indojavstream.com",527],["daftsex.org",528],["streamecho.top",529],["leeapk.com",530],["stevenuniverse.best",531],["tarnkappe.info",532],["crimsonscrolls.net",533],["nexusgames.to",534],["cricfy.net",535],["thehealthsite.com",536],["mangaread.org",537],["artru.net",538],["myhentaicomics.com",539],["liberation.fr",540],["officedepot.fr",540],["oui.sncf",540]]);
const exceptionsMap = new Map([["cloudflare.com",[0,240]],["oxy.edu",[12,434]],["disqus.com",[240]],["google.com",[240]],["chatango.com",[240,240]],["twitter.com",[240]],["youtube.com",[240]]]);
const hasEntities = true;
const hasAncestors = true;

const collectArgIndices = (hn, map, out) => {
    let argsIndices = map.get(hn);
    if ( argsIndices === undefined ) { return; }
    if ( typeof argsIndices !== 'number' ) {
        for ( const argsIndex of argsIndices ) {
            out.add(argsIndex);
        }
    } else {
        out.add(argsIndices);
    }
};

const indicesFromHostname = (hostname, suffix = '') => {
    const hnParts = hostname.split('.');
    const hnpartslen = hnParts.length;
    if ( hnpartslen === 0 ) { return; }
    for ( let i = 0; i < hnpartslen; i++ ) {
        const hn = `${hnParts.slice(i).join('.')}${suffix}`;
        collectArgIndices(hn, hostnamesMap, todoIndices);
        collectArgIndices(hn, exceptionsMap, tonotdoIndices);
    }
    if ( hasEntities ) {
        const n = hnpartslen - 1;
        for ( let i = 0; i < n; i++ ) {
            for ( let j = n; j > i; j-- ) {
                const en = `${hnParts.slice(i,j).join('.')}.*${suffix}`;
                collectArgIndices(en, hostnamesMap, todoIndices);
                collectArgIndices(en, exceptionsMap, tonotdoIndices);
            }
        }
    }
};

const entries = (( ) => {
    const docloc = document.location;
    const origins = [ docloc.origin ];
    if ( docloc.ancestorOrigins ) {
        origins.push(...docloc.ancestorOrigins);
    }
    return origins.map((origin, i) => {
        const beg = origin.lastIndexOf('://');
        if ( beg === -1 ) { return; }
        const hn = origin.slice(beg+3)
        const end = hn.indexOf(':');
        return { hn: end === -1 ? hn : hn.slice(0, end), i };
    }).filter(a => a !== undefined);
})();
if ( entries.length === 0 ) { return; }

const todoIndices = new Set();
const tonotdoIndices = new Set();

indicesFromHostname(entries[0].hn);
if ( hasAncestors ) {
    for ( const entry of entries ) {
        if ( entry.i === 0 ) { continue; }
        indicesFromHostname(entry.hn, '>>');
    }
}

// Apply scriplets
for ( const i of todoIndices ) {
    if ( tonotdoIndices.has(i) ) { continue; }
    try { abortCurrentScript(...argsList[i]); }
    catch { }
}

/******************************************************************************/

// End of local scope
})();

void 0;
