/*
Create all the context menu items.
*/
chrome.contextMenus.create({
    title: `Look up "%s"`,
    contexts:["selection"],
    id: "lookup-dictionary",
}, onCreated);

/*
The click event listener, where we perform the appropriate action given the
ID of the menu item that was clicked.
*/
chrome.contextMenus.onClicked.addListener((info, tab) => {
    switch (info.menuItemId) {
        case "lookup-dictionary":
        log(`Selected text: ${info.selectionText}`);
        lookup(info.selectionText);
        break;
    }
});

chrome.tabs.onRemoved.addListener(tabId => activeOldTabIfEligible(tabId));

/*
Called when the item has been created, or when creation failed due to an error.
We'll just log success/failure here.
*/
function onCreated() {
    log("cam-onCreated");
    if (chrome.runtime.lastError) {
        log(`Error: ${chrome.runtime.lastError}`);
    } else {
        log("cam-onCreated successsully");
    }
}

function lookup(text) {
  chrome.storage.sync.get(['recentDictionaries'], function(result) {
    let list = result.recentDictionaries;

    let dictionary;
    if (list && list[0] && list[0][1]) {
        dictionary = list[0][1];
    } else {
        dictionary = 'english';
    }
    log(`lookup: selectedDictionary: ${dictionary}`);

    let dictionaryTarget = `https://dictionary.cambridge.org/search/${dictionary}/direct/?q=`;
    let url = dictionaryTarget + text;
    openCambridgeTab(url);
  });
}

/*
Open page to look up @text in new tab.
*/
function openCambridgeTab(url) {
    // var dictionaryTarget = "https://dictionary.cambridge.org/search/english/direct/?q=";
    // var url = dictionaryTarget + text;

    chrome.tabs.query({ active:true, currentWindow:true }, function(tabs) {
        var currentTab = tabs[0];
        openTab(currentTab.id, url, currentTab.index + 1);
    });
}

/*
Open @url in in new tab created at position @index in tab list.
*/
function openTab(currentTabId, url, index) {
    chrome.tabs.create({
        url: url,
        index: index
    }, tab => {
        saveHistory(currentTabId, tab.id);
    });
}

function saveHistory(originId, popupId) {
    arrHistory.push([originId, popupId]);
}

/*
 Array of [originPageId, dictionaryPageId].
 If dictionaryPageId is closed, originPageId will be active.
 */
var arrHistory = new Array();

/*
When any tab is closed, check if this tab is popped-up to look up dictionary
then former page should be active.
*/
function activeOldTabIfEligible(closedTabId) {
    if (!arrHistory) {
        return;
    }

    let tobeRemoved;
    for (let i = 0; i < arrHistory.length; i++) {
        let pair = arrHistory[i];
        if (pair) {
            if (pair[1] && pair[1] == closedTabId) {
                tobeRemoved = i;
                if (pair[0]) {
                    activeTab(pair[0]);
                }
                break;
            }
        }
    }
    if (tobeRemoved && tobeRemoved >= 0) {
        arrHistory.splice(tobeRemoved, 1);
    }
}

/////////////////////////////////////////////
// UTILITIES FUNCTIONS
/////////////////////////////////////////////
function log(sms) {
    if (LOG_ENABLE) {
        chrome.extension.getBackgroundPage().console.log(`background.js: ${sms}`);
    }
}

/////////////////////////////////////////////
// GLOBAL FUNCTIONS
/////////////////////////////////////////////
function activeTab(tabId) {
    chrome.tabs.update(
        tabId,
        {
            active: true
        }
    );
}

/////////////////////////////////////////////
// GLOBAL VARIABLES
/////////////////////////////////////////////
var LOG_ENABLE = false;
