'use strict';

document.addEventListener('DOMContentLoaded', function() {
    log("DOMContentLoaded");
    init();
});

function clearRecent() {
    log(`clearRecent`);
    // Keep the last selection
    if (typeof listRecentDictionaries[0] === 'undefined') { // does not exist
        listRecentDictionaries = new Array();
    } else {
        listRecentDictionaries = new Array(listRecentDictionaries[0]);
    }
    saveRecentDictionaries(listRecentDictionaries, reloadDictionary);
}

function reloadDictionary() {
    clearPreviousLoaded();
    loadDictionary();
}

function clearPreviousLoaded() {
    document.getElementById("action-clear").removeEventListener("click", clearRecent);
    document.querySelector("#english-dictionary").innerHTML = '';
    document.querySelector("#other-dictionary").innerHTML = '';
    document.querySelector("#recent-dictionary").innerHTML = '';
}

function init() {
    loadDictionary();
}

function loadDictionary() {
     chrome.storage.sync.get(['recentDictionaries'], function(result) {
         log(`loadDictionary: ${result.recentDictionaries}`);
         listRecentDictionaries = result.recentDictionaries;

         if (!Array.isArray(listRecentDictionaries) ||
             !listRecentDictionaries.length ||
             !Array.isArray(listRecentDictionaries[0])) {
             // Set English dictionary as default
             listRecentDictionaries = new Array(listEnglishDictionaries[0]);
         }

         showDictionaryOptions();
     });
 }

function showDictionaryOptions() {
    let selectedDictionary = listRecentDictionaries[0][1];

    let divEngDictionary = document.querySelector("#english-dictionary");
    fillDictionaryToDiv(divEngDictionary, listEnglishDictionaries, selectedDictionary);

    let divOtherDictionary = document.querySelector("#other-dictionary");
    fillDictionaryToDiv(divOtherDictionary, listOtherDictionaries, selectedDictionary);

    let divRecentDictionary = document.querySelector("#recent-dictionary");
    let listRecent = listRecentDictionaries.slice(1, listRecentDictionaries.length);
    if (listRecent && listRecent.length) {
        fillDictionaryToDiv(divRecentDictionary, listRecent, selectedDictionary);
        // Add listener to 'clear recent'
        document.getElementById("action-clear").addEventListener("click", clearRecent);
    } else {
        // Hide 'recent' block if there is no recent item.
        document.querySelector("#recent-title").style.display = 'none';
        divRecentDictionary.style.display = 'none';
    }
}

function fillDictionaryToDiv(divDictionary, listDictionary, selectedDictionary) {
    for (let i = 0; i < listDictionary.length; i++) {
        let item = document.createElement("div");
        item.innerHTML = listDictionary[i][0];

        let value = listDictionary[i][1];
        // set the CSS class
        if (value == selectedDictionary) {
            console.log(`fillDictionaryToDiv: choosen: ${value}`);
            item.className = "item choosen";
        } else {
            item.className = "item";
        }

        item.addEventListener('click', itemClick);

        divDictionary.appendChild(item);
    }
}

function itemClick(e) {
    let item = e.target;
    if (item) {
        let dictionary = item.innerHTML;
        let pair = listEnglishDictionaries.find(element => element[0] == dictionary);
        if (!pair) {
            pair = listOtherDictionaries.find(element => element[0] == dictionary);
        }
        if (pair) {
            saveSelectedDictionary(pair);
            window.close();
        }
    }
}

function saveSelectedDictionary(pairDictionary) {
    if (!pairDictionary) {
        log('saveSelectedDictionary: Err: Nothing selected!');
        return;
    }
    log(`saveSelectedDictionary: ${pairDictionary}`);

    if (!listRecentDictionaries) {
        listRecentDictionaries = new Array();
        listRecentDictionaries.unshift(pairDictionary);
    } else {
        // Remove occurence of pairDictionary and add to starting of listRecentDictionaries.
        let currentId = listRecentDictionaries.findIndex(pair => pair[1] == pairDictionary[1]);
        log(`saveSelectedDictionary currentID = ${currentId} list = ${listRecentDictionaries}`);
        if (currentId != 0) {
            if (currentId > 0) {
                listRecentDictionaries.splice(currentId, 1);
            }
            listRecentDictionaries.unshift(pairDictionary);
        }
        listRecentDictionaries.splice(8, listRecentDictionaries.length);
    }

    // Save it using the Chrome extension storage API.
    saveRecentDictionaries(listRecentDictionaries);
}

// Saving using the Chrome extension storage API.
function saveRecentDictionaries(listToBeSaved, actionWhenDone) {
    chrome.storage.sync.set({
        ['recentDictionaries']: listToBeSaved
    }, function() {
        log('saveRecentDictionaries: saved');
        actionWhenDone();
    });
}

var listEnglishDictionaries = [
    ['English - English', 'english'],
    ['English - Arabic', 'english-arabic'],
    ['English - Catalan', 'english-catalan'],
    ['English - Chinese (Simplified)', 'english-chinese-simplified'],
    ['English - Chinese (Traditional)', 'english-chinese-traditional'],
    ['English - Czech', 'english-czech'],
    ['English - Danish', 'english-danish'],
    ['English - French', 'english-french'],
    ['English - German', 'english-german'],
    ['English - Indonesian', 'english-indonesian'],
    ['English - Italian', 'english-italian'],
    ['English - Japanese', 'english-japanese'],
    ['English - Korean', 'english-korean'],
    ['English - Malay', 'english-malay'],
    ['English - Norwegian', 'english-norwegian'],
    ['English - Polish', 'english-polish'],
    ['English - Portuguese', 'english-portuguese'],
    ['English - Russian', 'english-russian'],
    ['English - Spanish', 'english-spanish'],
    ['English - Thai', 'english-thai'],
    ['English - Turkish', 'english-turkish'],
    ['English - Vietnamese', 'english-vietnamese']
];

var listOtherDictionaries = [
    ['Dutch - English', 'dutch-english'],
    ['French - English', 'french-english'],
    ['German - English', 'german-english'],
    ['Indonesian - English', 'indonesian-english'],
    ['Italian - English', 'italian-english'],
    ['Japanese - English', 'japanese-english'],
    ['Polish - English', 'polish-english'],
    ['Portuguese - English', 'portuguese-english'],
    ['Spanish - English', 'spanish-english']
];

var KEY_RECENT_DICTIONARY = "recentDictionaries";
var listRecentDictionaries = new Array();

/////////////////////////////////////////////
// SUPPORT FUNCTIONS
/////////////////////////////////////////////
function log(sms) {
    if (LOG_ENABLE) {
        chrome.extension.getBackgroundPage().console.log(`popup.js: ${sms}`);
    }
}

var LOG_ENABLE = false;
